/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Connection;
import com.pcloud.networking.client.ConnectionProvider;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.client.FixedLengthSource;
import com.pcloud.networking.client.Interactor;
import com.pcloud.networking.client.MultiCall;
import com.pcloud.networking.client.MultiCallback;
import com.pcloud.networking.client.MultiResponse;
import com.pcloud.networking.client.Request;
import com.pcloud.networking.client.RequestInterceptor;
import com.pcloud.networking.client.Response;
import com.pcloud.networking.client.ResponseBody;
import com.pcloud.networking.client.ResponseBodyUtils;
import com.pcloud.networking.client.ResponseData;
import com.pcloud.networking.client.SelfEndingBytesReader;
import com.pcloud.networking.protocol.BytesReader;
import com.pcloud.networking.protocol.BytesWriter;
import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolResponseReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

class RealMultiCall
implements MultiCall {
    private static final int RESPONSE_LENGTH = 4;
    private volatile boolean executed;
    private volatile boolean cancelled;
    private final List<Request> requests;
    private Connection connection;
    private final ExecutorService callExecutor;
    private final List<RequestInterceptor> interceptors;
    private final ConnectionProvider connectionProvider;
    private final Endpoint endpoint;

    RealMultiCall(List<Request> requests, ExecutorService callExecutor, List<RequestInterceptor> interceptors, ConnectionProvider connectionProvider, Endpoint endpoint) {
        this.requests = requests;
        this.callExecutor = callExecutor;
        this.connectionProvider = connectionProvider;
        this.interceptors = interceptors;
        this.endpoint = endpoint;
    }

    @Override
    public List<Request> requests() {
        return this.requests;
    }

    @Override
    public MultiResponse execute() throws IOException {
        this.checkAndMarkExecuted();
        return this.getMultiResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiResponse getMultiResponse() throws IOException {
        this.throwIfCancelled();
        Connection connection = this.endpoint != null ? this.connectionProvider.obtainConnection(this.endpoint) : this.connectionProvider.obtainConnection();
        RealMultiCall realMultiCall = this;
        synchronized (realMultiCall) {
            this.connection = connection;
        }
        boolean allResponsesRead = false;
        TreeMap<Integer, Response> responseMap = new TreeMap<Integer, Response>();
        try {
            int completedCount;
            this.writeRequests(connection);
            int expectedCount = this.requests.size();
            this.initializeResponseMap(responseMap, expectedCount);
            for (completedCount = 0; completedCount < expectedCount && !this.isCancelled(); ++completedCount) {
                this.readNextBufferedResponse(connection, responseMap);
            }
            allResponsesRead = completedCount == expectedCount;
        }
        finally {
            if (allResponsesRead) {
                this.connectionProvider.recycleConnection(connection);
            } else {
                this.closeAndClearCompletedResponses(responseMap);
                IOUtils.closeQuietly((Closeable)connection);
            }
            RealMultiCall realMultiCall2 = this;
            synchronized (realMultiCall2) {
                this.connection = null;
            }
        }
        return new MultiResponse(new ArrayList<Response>(responseMap.values()));
    }

    @Override
    public MultiResponse enqueueAndWait() throws IOException, InterruptedException {
        this.checkAndMarkExecuted();
        try {
            return this.callExecutor.submit(new Callable<MultiResponse>(){

                @Override
                public MultiResponse call() throws IOException {
                    return RealMultiCall.this.getMultiResponse();
                }
            }).get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (CancellationException e) {
            throw new IOException(e);
        }
    }

    @Override
    public MultiResponse enqueueAndWait(long timeout, TimeUnit timeUnit) throws IOException, InterruptedException, TimeoutException {
        this.checkAndMarkExecuted();
        try {
            return this.callExecutor.submit(new Callable<MultiResponse>(){

                @Override
                public MultiResponse call() throws IOException {
                    return RealMultiCall.this.getMultiResponse();
                }
            }).get(timeout, timeUnit);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
    }

    @Override
    public void enqueue(final MultiCallback callback) {
        this.checkAndMarkExecuted();
        this.callExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block26: {
                    block24: {
                        Connection connection;
                        TreeMap responseMap;
                        block23: {
                            int expectedCount = RealMultiCall.this.requests.size();
                            responseMap = new TreeMap();
                            RealMultiCall.this.initializeResponseMap(responseMap, expectedCount);
                            connection = null;
                            boolean allResponsesRead = false;
                            boolean callingCallbackMethod = false;
                            try {
                                int completedCount;
                                RealMultiCall.this.throwIfCancelled();
                                connection = RealMultiCall.this.endpoint != null ? RealMultiCall.this.connectionProvider.obtainConnection(RealMultiCall.this.endpoint) : RealMultiCall.this.connectionProvider.obtainConnection();
                                3 var6_6 = this;
                                synchronized (var6_6) {
                                    RealMultiCall.this.connection = connection;
                                }
                                RealMultiCall.this.writeRequests(connection);
                                for (completedCount = 0; completedCount < expectedCount && !RealMultiCall.this.isCancelled(); ++completedCount) {
                                    int key = RealMultiCall.this.readNextBufferedResponse(connection, responseMap);
                                    if (RealMultiCall.this.isCancelled()) continue;
                                    callingCallbackMethod = true;
                                    callback.onResponse(RealMultiCall.this, key, (Response)responseMap.get(key));
                                    callingCallbackMethod = false;
                                }
                                boolean bl = allResponsesRead = expectedCount == completedCount;
                                if (!RealMultiCall.this.isCancelled()) {
                                    MultiResponse response = new MultiResponse(new ArrayList<Response>(responseMap.values()));
                                    callingCallbackMethod = true;
                                    callback.onComplete(RealMultiCall.this, response);
                                    callingCallbackMethod = false;
                                }
                                if (!allResponsesRead) break block23;
                                RealMultiCall.this.connectionProvider.recycleConnection(connection);
                                break block24;
                            }
                            catch (IOException e) {
                                block25: {
                                    try {
                                        List<Response> completedResponses = Collections.unmodifiableList(new ArrayList(responseMap.values()));
                                        if (!callingCallbackMethod) {
                                            if (!RealMultiCall.this.isCancelled()) {
                                                callback.onFailure(RealMultiCall.this, e, completedResponses);
                                            }
                                        } else {
                                            RealMultiCall.this.closeAndClearCompletedResponses(responseMap);
                                        }
                                        if (!allResponsesRead) break block25;
                                        RealMultiCall.this.connectionProvider.recycleConnection(connection);
                                    }
                                    catch (Throwable throwable) {
                                        if (allResponsesRead) {
                                            RealMultiCall.this.connectionProvider.recycleConnection(connection);
                                        } else {
                                            IOUtils.closeQuietly(connection);
                                            RealMultiCall.this.closeAndClearCompletedResponses(responseMap);
                                        }
                                        3 var11_18 = this;
                                        synchronized (var11_18) {
                                            RealMultiCall.this.connection = null;
                                        }
                                        throw throwable;
                                    }
                                }
                                IOUtils.closeQuietly((Closeable)connection);
                                RealMultiCall.this.closeAndClearCompletedResponses(responseMap);
                                3 var6_10 = this;
                                synchronized (var6_10) {
                                    RealMultiCall.this.connection = null;
                                    break block26;
                                }
                            }
                        }
                        IOUtils.closeQuietly((Closeable)connection);
                        RealMultiCall.this.closeAndClearCompletedResponses(responseMap);
                    }
                    3 completedCount = this;
                    synchronized (completedCount) {
                        RealMultiCall.this.connection = null;
                    }
                }
            }
        });
    }

    @Override
    public Interactor start() {
        this.checkAndMarkExecuted();
        return new RealInteractor();
    }

    @Override
    public boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (!this.cancelled) {
            RealMultiCall realMultiCall = this;
            synchronized (realMultiCall) {
                this.cancelled = true;
                IOUtils.closeQuietly((Closeable)this.connection);
                this.connection = null;
            }
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public MultiCall clone() {
        return new RealMultiCall(this.requests, this.callExecutor, this.interceptors, this.connectionProvider, this.endpoint);
    }

    private void initializeResponseMap(Map<Integer, Response> responseMap, int expectedCount) {
        for (int i = 0; i < expectedCount; ++i) {
            responseMap.put(i, null);
        }
    }

    private void closeAndClearCompletedResponses(Map<?, ? extends Closeable> responseMap) {
        for (Closeable closeable : responseMap.values()) {
            IOUtils.closeQuietly((Closeable)closeable);
        }
        responseMap.clear();
    }

    private void writeRequests(Connection connection) throws IOException {
        long requestKey = 0L;
        for (Request request : this.requests) {
            this.writeRequest(connection, requestKey, request);
            ++requestKey;
        }
    }

    private void writeRequest(Connection connection, long requestKey, Request request) throws IOException {
        BytesWriter writer = new BytesWriter(connection.sink());
        writer.beginRequest().writeMethodName(request.methodName());
        if (request.dataSource() != null) {
            writer.writeData(request.dataSource());
        }
        for (RequestInterceptor r : this.interceptors) {
            r.intercept(request, (ProtocolWriter)writer);
        }
        request.body().writeTo((ProtocolWriter)writer);
        writer.writeName("id").writeValue(requestKey);
        writer.endRequest();
        connection.sink().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndMarkExecuted() {
        RealMultiCall realMultiCall = this;
        synchronized (realMultiCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
    }

    private void throwIfCancelled() throws IOException {
        if (this.cancelled) {
            throw new IOException("Cancelled.");
        }
    }

    private int readNextBufferedResponse(Connection connection, Map<Integer, Response> responseMap) throws IOException {
        BufferedResponseBody responseBody = this.createBufferedResponseBody(connection);
        int id = this.scanResponseParameters((ProtocolResponseReader)((ResponseBody)responseBody).reader(), true);
        Response response = Response.create().request(this.requests.get(id)).responseBody(responseBody).build();
        responseMap.put(id, response);
        return id;
    }

    private BufferedResponseBody createBufferedResponseBody(Connection connection) throws IOException {
        long responseLength = IOUtils.peekNumberLe((BufferedSource)connection.source(), (int)4);
        Buffer responseBuffer = new Buffer();
        connection.source().read(responseBuffer, responseLength + 4L);
        SelfEndingBytesReader reader = new SelfEndingBytesReader((BufferedSource)responseBuffer);
        RealMultiCall.checkPeekAndActualContentLengths(responseLength, reader.beginResponse());
        return new BufferedResponseBody(responseBuffer, (ProtocolReader)reader, responseLength, connection.endpoint());
    }

    private int scanResponseParameters(ProtocolResponseReader reader, boolean readUntilEnd) throws IOException {
        ProtocolResponseReader peekingReader = reader.newPeekingReader();
        peekingReader.beginObject();
        int id = -1;
        long dataLength = -1L;
        while (peekingReader.hasNext()) {
            String name = peekingReader.readString();
            if (name.equals("id")) {
                id = (int)peekingReader.readNumber();
            } else {
                peekingReader.skipValue();
            }
            if (readUntilEnd || (dataLength = peekingReader.dataContentLength()) == -1L) continue;
            break;
        }
        if (dataLength > 0L) {
            throw new IOException("MultiCalls are not supported for responses returning data.");
        }
        if (id == -1) {
            throw new IOException("Response is missing its id.");
        }
        if (id < 0 || id >= this.requests.size() || this.requests.get(id) == null) {
            throw new IOException("Received a response with an unknown id '" + id + "'.");
        }
        return id;
    }

    private static void checkPeekAndActualContentLengths(long peeked, long actual) throws IOException {
        if (peeked != actual) {
            throw new AssertionError((Object)"Peeked and actual content lengths are different.");
        }
    }

    private class RealInteractor
    implements Interactor {
        private final int requestCount;
        private final AtomicInteger remainingRequests;
        private final AtomicInteger handledResponses;
        private final AtomicReference<Response> lastResultReference;
        private volatile boolean closed;

        private RealInteractor() {
            this.requestCount = RealMultiCall.this.requests.size();
            this.remainingRequests = new AtomicInteger(this.requestCount);
            this.handledResponses = new AtomicInteger(0);
            this.lastResultReference = new AtomicReference<Object>(null);
        }

        @Override
        public boolean hasMoreRequests() {
            return this.remainingRequests.get() > 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int submitRequests(int count) throws IOException {
            int sent;
            Connection connection;
            if (count < 0) {
                throw new IllegalArgumentException("Count parameter cannot be a negative number.");
            }
            RealInteractor realInteractor = this;
            synchronized (realInteractor) {
                if (!RealMultiCall.this.isCancelled() && !this.closed && RealMultiCall.this.connection == null) {
                    RealMultiCall.this.connection = RealMultiCall.this.endpoint != null ? RealMultiCall.this.connectionProvider.obtainConnection(RealMultiCall.this.endpoint) : RealMultiCall.this.connectionProvider.obtainConnection();
                }
                connection = RealMultiCall.this.connection;
            }
            RealMultiCall.this.throwIfCancelled();
            this.throwIfClosed();
            for (sent = 0; this.remainingRequests.get() > 0 && sent < count && !RealMultiCall.this.isCancelled(); ++sent) {
                int key = this.requestCount - this.remainingRequests.get();
                RealMultiCall.this.writeRequest(connection, key, (Request)RealMultiCall.this.requests.get(key));
                this.remainingRequests.decrementAndGet();
            }
            return sent;
        }

        @Override
        public boolean hasNextResponse() {
            return this.handledResponses.get() < this.requestCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Response nextResponse() throws IOException {
            FixedLengthResponseBody responseBody;
            RealMultiCall.this.throwIfCancelled();
            this.throwIfClosed();
            boolean readSuccess = false;
            if (!this.hasNextResponse()) {
                throw new IllegalStateException("Cannot read next response, no more elements to read.");
            }
            if (this.handledResponses.get() == this.requestCount - this.remainingRequests.get()) {
                throw new IllegalStateException("Cannot read next response, submit at least one more request.");
            }
            Response lastResult = this.lastResultReference.get();
            if (lastResult != null && (responseBody = (FixedLengthResponseBody)lastResult.responseBody()).bytesRemaining() > 0L) {
                throw new IOException("Previously returned Result object has not been read fully.");
            }
            try {
                Connection connection;
                RealInteractor realInteractor = this;
                synchronized (realInteractor) {
                    connection = RealMultiCall.this.connection;
                }
                Response result = this.nextUnsafeResponse(connection);
                this.lastResultReference.set(result);
                this.handledResponses.incrementAndGet();
                readSuccess = true;
                Response response = result;
                return response;
            }
            finally {
                if (!readSuccess) {
                    RealInteractor realInteractor = this;
                    synchronized (realInteractor) {
                        IOUtils.closeQuietly((Closeable)RealMultiCall.this.connection);
                        RealMultiCall.this.connection = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.closed) {
                RealInteractor realInteractor = this;
                synchronized (realInteractor) {
                    this.closed = true;
                    if (RealMultiCall.this.connection != null) {
                        FixedLengthResponseBody body;
                        Response lastResponse;
                        if (!this.hasNextResponse() && (lastResponse = this.lastResultReference.get()) != null && (body = (FixedLengthResponseBody)lastResponse.responseBody()).bytesRemaining() == 0L) {
                            RealMultiCall.this.connectionProvider.recycleConnection(RealMultiCall.this.connection);
                            RealMultiCall.this.connection = null;
                            return;
                        }
                        IOUtils.closeQuietly((Closeable)RealMultiCall.this.connection);
                        RealMultiCall.this.connection = null;
                    }
                }
            }
        }

        private Response nextUnsafeResponse(Connection connection) throws IOException {
            FixedLengthResponseBody responseBody = this.createUnsafeResponseBody(connection);
            int id = RealMultiCall.this.scanResponseParameters((ProtocolResponseReader)responseBody.reader(), true);
            return Response.create().request((Request)RealMultiCall.this.requests.get(id)).responseBody(responseBody).build();
        }

        private FixedLengthResponseBody createUnsafeResponseBody(final Connection connection) throws IOException {
            long responseLength = IOUtils.peekNumberLe((BufferedSource)connection.source(), (int)4);
            FixedLengthSource source = new FixedLengthSource((Source)connection.source(), responseLength + 4L, 0L, TimeUnit.MILLISECONDS){

                @Override
                protected void exhausted(boolean reuseSource) {
                    if (!reuseSource) {
                        IOUtils.closeQuietly((Closeable)connection);
                    }
                }
            };
            BufferedSource bufferedSource = Okio.buffer((Source)source);
            NoDataBytesReader reader = new NoDataBytesReader(bufferedSource);
            RealMultiCall.checkPeekAndActualContentLengths(responseLength, reader.beginResponse());
            return new FixedLengthResponseBody(bufferedSource, source, reader, responseLength, connection.endpoint());
        }

        private void throwIfClosed() throws IOException {
            if (this.closed) {
                throw new IOException("This Interactor has been closed.");
            }
        }
    }

    private static class FixedLengthResponseBody
    extends ResponseBody {
        private final BufferedSource bufferedSource;
        private final FixedLengthSource source;
        private final ProtocolReader reader;
        private final long contentLength;
        private final Endpoint endpoint;

        FixedLengthResponseBody(BufferedSource bufferedSource, FixedLengthSource source, BytesReader reader, long contentLength, Endpoint endpoint) {
            this.bufferedSource = bufferedSource;
            this.source = source;
            this.reader = reader;
            this.contentLength = contentLength;
            this.endpoint = endpoint;
        }

        @Override
        public ProtocolReader reader() {
            return this.reader;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public ResponseData data() throws IOException {
            return null;
        }

        @Override
        public Endpoint endpoint() {
            return this.endpoint;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            ResponseBodyUtils.checkNotAlreadyRead(this);
            this.bufferedSource.peek().readAll((Sink)sink);
            this.reader.beginObject();
            ResponseBodyUtils.skipRemainingValues(this);
        }

        @Override
        public void close() throws IOException {
            this.source.close();
        }

        long bytesRemaining() {
            return this.source.bytesRemaining();
        }
    }

    private static class BufferedResponseBody
    extends ResponseBody {
        private final Buffer source;
        private final ProtocolReader reader;
        private final long contentLength;
        private final Endpoint endpoint;

        BufferedResponseBody(Buffer source, ProtocolReader reader, long contentLength, Endpoint endpoint) {
            this.source = source;
            this.reader = reader;
            this.contentLength = contentLength;
            this.endpoint = endpoint;
        }

        @Override
        public ProtocolReader reader() {
            return this.reader;
        }

        @Override
        public long contentLength() {
            return this.contentLength;
        }

        @Override
        public ResponseData data() throws IOException {
            return null;
        }

        @Override
        public Endpoint endpoint() {
            return this.endpoint;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            ResponseBodyUtils.checkNotAlreadyRead(this);
            this.source.peek().readAll((Sink)sink);
            this.reader.beginObject();
            ResponseBodyUtils.skipRemainingValues(this);
        }

        @Override
        public void close() {
            this.source.close();
        }
    }

    private static class NoDataBytesReader
    extends SelfEndingBytesReader {
        NoDataBytesReader(BufferedSource bufferedSource) {
            super(bufferedSource);
        }

        public boolean endResponse() throws IOException {
            boolean hasData = super.endResponse();
            if (hasData) {
                throw new IOException("MultiCalls do not support calls that return data.");
            }
            return false;
        }
    }
}

