/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.ApiChannel;
import com.pcloud.networking.client.Connection;
import com.pcloud.networking.client.ConnectionProvider;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.protocol.BytesReader;
import com.pcloud.networking.protocol.BytesWriter;
import com.pcloud.networking.protocol.DataSource;
import com.pcloud.networking.protocol.ForwardingProtocolRequestWriter;
import com.pcloud.networking.protocol.ForwardingProtocolResponseReader;
import com.pcloud.networking.protocol.ProtocolRequestWriter;
import com.pcloud.networking.protocol.ProtocolResponseReader;
import com.pcloud.networking.protocol.TypeToken;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import okio.BufferedSink;

class RealApiChannel
implements ApiChannel {
    private final ConnectionProvider connectionProvider;
    private Connection connection;
    private final ProtocolRequestWriter writer;
    private final ProtocolResponseReader reader;
    private final Endpoint endpoint;
    private long startedRequests = 0L;
    private long startedResponses = 0L;
    private long completedRequests = 0L;
    private long completedResponses = 0L;
    private volatile boolean closed;
    private final Object counterLock = new Object();

    RealApiChannel(ConnectionProvider connectionProvider, Endpoint endpoint) throws IOException {
        this.connectionProvider = connectionProvider;
        this.connection = connectionProvider.obtainConnection(endpoint);
        this.endpoint = this.connection.endpoint();
        this.writer = new CountingProtocolRequestWriter((ProtocolRequestWriter)new BytesWriter(this.connection.sink()), this);
        this.reader = new CountingProtocolResponseReader((ProtocolResponseReader)new BytesReader(this.connection.source()), this);
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    @Override
    public ProtocolResponseReader reader() {
        return this.reader;
    }

    @Override
    public ProtocolRequestWriter writer() {
        return this.writer;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIdle() {
        Object object = this.counterLock;
        synchronized (object) {
            return this.startedRequests == this.completedRequests && this.startedResponses == this.completedResponses && this.completedRequests == this.completedResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.closed) {
            RealApiChannel realApiChannel = this;
            synchronized (realApiChannel) {
                if (!this.closed) {
                    this.closed = true;
                    if (this.isIdle()) {
                        this.connectionProvider.recycleConnection(this.connection);
                    } else {
                        IOUtils.closeQuietly((Closeable)this.connection);
                    }
                    this.connection = null;
                }
            }
        }
    }

    private void checkNotClosed() throws ClosedChannelException {
        if (this.closed) {
            throw new ClosedChannelException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRequest() {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.startedRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRequest() {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.completedRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startResponse() {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.startedResponses;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeResponse() {
        Object object = this.counterLock;
        synchronized (object) {
            ++this.completedResponses;
        }
    }

    private static class CountingProtocolRequestWriter
    extends ForwardingProtocolRequestWriter {
        private final RealApiChannel apiChannel;

        CountingProtocolRequestWriter(ProtocolRequestWriter delegate, RealApiChannel apiChannel) {
            super(delegate);
            this.apiChannel = apiChannel;
        }

        public ProtocolRequestWriter beginRequest() throws IOException {
            this.apiChannel.checkNotClosed();
            this.apiChannel.startRequest();
            super.beginRequest();
            return this;
        }

        public ProtocolRequestWriter writeData(DataSource source) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeData(source);
            return this;
        }

        public ProtocolRequestWriter writeMethodName(String name) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeMethodName(name);
            return this;
        }

        public ProtocolRequestWriter writeName(String name) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeName(name);
            return this;
        }

        public ProtocolRequestWriter writeValue(Object value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(String value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(double value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(float value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(long value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public ProtocolRequestWriter writeValue(boolean value) throws IOException {
            this.apiChannel.checkNotClosed();
            super.writeValue(value);
            return this;
        }

        public void close() {
            this.apiChannel.close();
        }

        public ProtocolRequestWriter endRequest() throws IOException {
            this.apiChannel.checkNotClosed();
            this.apiChannel.completeRequest();
            super.endRequest();
            return this;
        }
    }

    private static class CountingProtocolResponseReader
    extends ForwardingProtocolResponseReader {
        private final RealApiChannel apiChannel;

        CountingProtocolResponseReader(ProtocolResponseReader delegate, RealApiChannel apiChannel) {
            super(delegate);
            this.apiChannel = apiChannel;
        }

        public long beginResponse() throws IOException {
            this.apiChannel.checkNotClosed();
            this.apiChannel.startResponse();
            return super.beginResponse();
        }

        public boolean endResponse() throws IOException {
            this.apiChannel.checkNotClosed();
            boolean hasData = super.endResponse();
            if (!hasData) {
                this.apiChannel.completeResponse();
            }
            return hasData;
        }

        public void readData(BufferedSink sink) throws IOException {
            this.apiChannel.checkNotClosed();
            super.readData(sink);
            this.apiChannel.completeResponse();
        }

        public void readData(OutputStream outputStream) throws IOException {
            this.apiChannel.checkNotClosed();
            super.readData(outputStream);
            this.apiChannel.completeResponse();
        }

        public TypeToken peek() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.peek();
        }

        public void beginObject() throws IOException {
            this.apiChannel.checkNotClosed();
            super.beginObject();
        }

        public void beginArray() throws IOException {
            this.apiChannel.checkNotClosed();
            super.beginArray();
        }

        public void endArray() throws IOException {
            this.apiChannel.checkNotClosed();
            super.endArray();
        }

        public void endObject() throws IOException {
            this.apiChannel.checkNotClosed();
            super.endObject();
        }

        public boolean readBoolean() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.readBoolean();
        }

        public String readString() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.readString();
        }

        public long readNumber() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.readNumber();
        }

        public void close() {
            this.apiChannel.close();
        }

        public boolean hasNext() throws IOException {
            this.apiChannel.checkNotClosed();
            return super.hasNext();
        }

        public void skipValue() throws IOException {
            this.apiChannel.checkNotClosed();
            super.skipValue();
        }

        public ProtocolResponseReader newPeekingReader() {
            return new CountingProtocolResponseReader(super.newPeekingReader(), this.apiChannel);
        }
    }
}

