/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class Endpoint {
    public static final Endpoint DEFAULT = new Endpoint("binapi.pcloud.com", 443);
    private static final int MINIMUM_PORT_NUMBER = 0;
    private static final int MAXIMUM_PORT_NUMBER = 65535;
    private final String host;
    private final int port;

    public Endpoint(String host, int port) {
        if (host == null) {
            throw new IllegalArgumentException("The host argument cannot be null!");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("The port argument can range from 0 to 65535 inclusively");
        }
        this.host = host;
        this.port = port;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public SocketAddress socketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        if (this.port != endpoint.port) {
            return false;
        }
        return this.host.equals(endpoint.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

