/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import android.os.Build;
import com.pcloud.networking.client.Connection;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

class RealConnection
implements Connection {
    private static final boolean RUNNING_ON_ANDROID;
    private static final int VERSION_INT_OREO = 26;
    private final SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final Endpoint endpoint;
    private final UUID id = UUID.randomUUID();
    private final Executor cleanupExecutor;
    private Socket rawSocket;
    private SSLSocket socket;
    private BufferedSource source;
    private BufferedSink sink;
    private InputStream inputStream;
    private OutputStream outputStream;
    private InetAddress address;
    private long idleAtNanos;
    private volatile boolean connected;
    private volatile boolean closed;
    private int readTimeout = 0;
    private int writeTimeout = 0;

    RealConnection(SocketFactory socketFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, Endpoint endpoint, Executor cleanupExecutor) {
        this.socketFactory = socketFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.endpoint = endpoint;
        this.cleanupExecutor = cleanupExecutor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void connect(int connectTimeout, TimeUnit timeUnit) throws IOException {
        InetAddress address;
        SSLSocket socket;
        Socket rawSocket;
        block6: {
            this.checkNotClosed();
            rawSocket = null;
            socket = null;
            address = null;
            boolean connected = false;
            try {
                rawSocket = this.createSocket(this.endpoint, (int)timeUnit.toMillis(connectTimeout));
                address = rawSocket.getInetAddress();
                socket = this.upgradeSocket(rawSocket, this.endpoint);
                socket.setSoTimeout(0);
                connected = true;
                if (connected) break block6;
            }
            catch (Throwable throwable) {
                if (connected) throw throwable;
                IOUtils.closeQuietly(rawSocket);
                IOUtils.closeQuietly(socket);
                throw throwable;
            }
            IOUtils.closeQuietly((Socket)rawSocket);
            IOUtils.closeQuietly((Socket)socket);
        }
        RealConnection realConnection = this;
        synchronized (realConnection) {
            if (this.closed) {
                IOUtils.closeQuietly((Socket)rawSocket);
                IOUtils.closeQuietly((Socket)socket);
            } else {
                this.rawSocket = rawSocket;
                this.socket = socket;
                this.address = address;
                this.source = Okio.buffer((Source)this.createSource(socket));
                this.sink = Okio.buffer((Sink)this.createSink(socket));
                this.inputStream = this.source.inputStream();
                this.outputStream = this.sink.outputStream();
                this.connected = true;
                this.readTimeout(this.readTimeout(), TimeUnit.MILLISECONDS);
                this.writeTimeout(this.writeTimeout(), TimeUnit.MILLISECONDS);
            }
            return;
        }
    }

    protected Sink createSink(Socket socket) throws IOException {
        return Okio.sink((Socket)socket);
    }

    protected Source createSource(Socket socket) throws IOException {
        return Okio.source((Socket)socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream inputStream() throws IOException {
        this.checkConnected();
        RealConnection realConnection = this;
        synchronized (realConnection) {
            this.checkConnected();
            return this.inputStream;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutputStream outputStream() throws IOException {
        this.checkConnected();
        RealConnection realConnection = this;
        synchronized (realConnection) {
            this.checkConnected();
            return this.outputStream;
        }
    }

    @Override
    public Endpoint endpoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedSource source() throws IOException {
        this.checkConnected();
        RealConnection realConnection = this;
        synchronized (realConnection) {
            this.checkConnected();
            return this.source;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedSink sink() throws IOException {
        this.checkConnected();
        RealConnection realConnection = this;
        synchronized (realConnection) {
            this.checkConnected();
            return this.sink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isHealthy(boolean doExtensiveChecks) {
        block13: {
            BufferedSource source;
            SSLSocket socket;
            if (!this.connected || this.closed) {
                return false;
            }
            RealConnection realConnection = this;
            synchronized (realConnection) {
                if (!this.connected) {
                    return false;
                }
                socket = this.socket;
                source = this.source;
            }
            if (socket == null || source == null || socket.isClosed() || socket.isInputShutdown() || socket.isOutputShutdown()) {
                return false;
            }
            if (doExtensiveChecks) {
                boolean bl;
                this.checkNotClosed();
                int readTimeout2 = socket.getSoTimeout();
                try {
                    socket.setSoTimeout(1);
                    bl = !source.exhausted();
                }
                catch (Throwable throwable) {
                    try {
                        socket.setSoTimeout(readTimeout2);
                        throw throwable;
                    }
                    catch (SocketTimeoutException readTimeout2) {
                        break block13;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                socket.setSoTimeout(readTimeout2);
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIdle(long nowNanos) {
        RealConnection realConnection = this;
        synchronized (realConnection) {
            this.idleAtNanos = nowNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long idleAtNanos() {
        RealConnection realConnection = this;
        synchronized (realConnection) {
            return this.idleAtNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readTimeout(long timeout, TimeUnit timeUnit) throws IOException {
        RealConnection realConnection = this;
        synchronized (realConnection) {
            this.readTimeout = (int)timeUnit.toMillis(timeout);
            BufferedSource source = this.source();
            if (source != null) {
                source.timeout().timeout((long)this.readTimeout, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTimeout(long timeout, TimeUnit timeUnit) throws IOException {
        RealConnection realConnection = this;
        synchronized (realConnection) {
            this.writeTimeout = (int)timeUnit.toMillis(timeout);
            BufferedSink sink = this.sink();
            if (sink != null) {
                sink.timeout().timeout((long)this.writeTimeout, TimeUnit.MILLISECONDS);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readTimeout() {
        RealConnection realConnection = this;
        synchronized (realConnection) {
            return this.readTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeTimeout() {
        RealConnection realConnection = this;
        synchronized (realConnection) {
            return this.writeTimeout;
        }
    }

    @Override
    public void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean mayBlock) {
        if (!this.closed) {
            RealConnection realConnection = this;
            synchronized (realConnection) {
                if (!this.closed) {
                    this.connected = false;
                    IOUtils.closeQuietly((Socket)this.rawSocket);
                    this.rawSocket = null;
                    this.inputStream = null;
                    this.outputStream = null;
                    this.source = null;
                    this.sink = null;
                    this.closed = true;
                    if (this.socket != null) {
                        this.closeSSLSocket(this.socket, mayBlock);
                        this.socket = null;
                    }
                }
            }
        }
    }

    private void closeSSLSocket(SSLSocket socket, boolean mayBlock) {
        if (!mayBlock) {
            try {
                this.cleanupExecutor.execute(new CloseOperation(socket));
            }
            catch (RejectedExecutionException e) {
                IOUtils.closeQuietly((Socket)socket);
            }
        } else {
            IOUtils.closeQuietly((Socket)socket);
        }
    }

    public String toString() {
        return "Connection(\"" + this.endpoint() + "\")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Socket createSocket(Endpoint endpoint, int connectTimeout) throws IOException {
        Socket socket = null;
        boolean connectionSucceeded = false;
        try {
            socket = this.socketFactory.createSocket();
            if (RUNNING_ON_ANDROID) {
                this.connectSocketAndroid(socket, endpoint, connectTimeout);
            } else {
                this.connectSocketJava(socket, endpoint, connectTimeout);
            }
            connectionSucceeded = true;
            Socket socket2 = socket;
            return socket2;
        }
        finally {
            if (!connectionSucceeded) {
                IOUtils.closeQuietly((Socket)socket);
            }
        }
    }

    private void connectSocketJava(Socket socket, Endpoint endpoint, int connectTimeout) throws IOException {
        socket.setSoTimeout(this.readTimeout());
        socket.connect(endpoint.socketAddress(), connectTimeout);
    }

    private void connectSocketAndroid(Socket socket, Endpoint endpoint, int connectTimeout) throws IOException {
        try {
            socket.setSoTimeout(this.readTimeout());
            socket.connect(endpoint.socketAddress(), connectTimeout);
        }
        catch (AssertionError e) {
            if (IOUtils.isAndroidGetsocknameError((AssertionError)e)) {
                throw new IOException((Throwable)((Object)e));
            }
            throw e;
        }
        catch (ClassCastException e) {
            if (Build.VERSION.SDK_INT == 26) {
                throw new IOException("Exception in connect", e);
            }
            throw e;
        }
    }

    private SSLSocket upgradeSocket(Socket rawSocket, Endpoint endpoint) throws IOException {
        SSLSocket sSLSocket;
        block8: {
            SSLSocket socket = null;
            boolean connectionSucceeded = false;
            try {
                Socket newSocket = this.sslSocketFactory.createSocket(rawSocket, endpoint.host(), endpoint.port(), true);
                if (!(newSocket instanceof SSLSocket)) {
                    IOUtils.closeQuietly((Socket)newSocket);
                    throw new IllegalStateException("The SSLSocketFactory did not return a SSLSocket. ");
                }
                socket = (SSLSocket)newSocket;
                socket.startHandshake();
                if (!this.hostnameVerifier.verify(endpoint.host(), socket.getSession())) {
                    throw new SSLPeerUnverifiedException("Hostname " + endpoint.host() + " not verified:");
                }
                connectionSucceeded = true;
                sSLSocket = socket;
                if (connectionSucceeded) break block8;
            }
            catch (AssertionError e) {
                try {
                    if (IOUtils.isAndroidGetsocknameError((AssertionError)e)) {
                        throw new IOException((Throwable)((Object)e));
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    if (!connectionSucceeded) {
                        IOUtils.closeQuietly(socket);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Socket)socket);
        }
        return sSLSocket;
    }

    private void checkConnected() throws IOException {
        if (!this.connected) {
            throw new IOException("Connection is not connected.");
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("Connection is closed.");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RealConnection that = (RealConnection)o;
        if (!this.endpoint.equals(that.endpoint)) {
            return false;
        }
        return this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.endpoint.hashCode();
        result = 31 * result + this.id.hashCode();
        return result;
    }

    static {
        boolean isAndroid = false;
        try {
            Class.forName("android.os.Build");
            isAndroid = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            RUNNING_ON_ANDROID = isAndroid;
        }
    }

    private static class CloseOperation
    implements Runnable {
        private final Closeable closeable;

        CloseOperation(Closeable closeable) {
            this.closeable = closeable;
        }

        @Override
        public void run() {
            IOUtils.closeQuietly((Closeable)this.closeable);
        }
    }
}

