/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.client.RequestBody;
import com.pcloud.networking.protocol.DataSource;

public class Request {
    private final Endpoint endpoint;
    private final String methodName;
    private final RequestBody body;
    private final DataSource dataSource;

    public static Builder create() {
        return new Builder();
    }

    Request(Builder builder) {
        this.methodName = builder.methodName;
        this.body = builder.body;
        this.dataSource = builder.dataSource;
        this.endpoint = builder.endpoint;
    }

    public String methodName() {
        return this.methodName;
    }

    public RequestBody body() {
        return this.body;
    }

    public DataSource dataSource() {
        return this.dataSource;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Builder newRequest() {
        return new Builder(this);
    }

    public String toString() {
        return String.format("Method:'%s', hasData=%s%n%s", this.methodName, this.dataSource != null, this.body.toString());
    }

    public static class Builder {
        private String methodName;
        private RequestBody body;
        private DataSource dataSource;
        private Endpoint endpoint;

        private Builder() {
        }

        private Builder(Request request) {
            this.methodName = request.methodName;
            this.body = request.body;
            this.dataSource = request.dataSource;
            this.endpoint = request.endpoint;
        }

        public Builder methodName(String methodName) {
            if (methodName == null) {
                throw new IllegalArgumentException("Method name cannot be null.");
            }
            this.methodName = methodName;
            return this;
        }

        public Builder dataSource(DataSource source) {
            this.dataSource = source;
            return this;
        }

        public Builder body(RequestBody body) {
            if (body == null) {
                throw new IllegalArgumentException("RequestBody argument cannot be null.");
            }
            this.body = body;
            return this;
        }

        public Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Request build() {
            return new Request(this);
        }
    }
}

