/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Call;
import com.pcloud.networking.client.Callback;
import com.pcloud.networking.client.Connection;
import com.pcloud.networking.client.ConnectionProvider;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.client.FixedLengthSource;
import com.pcloud.networking.client.Request;
import com.pcloud.networking.client.RequestInterceptor;
import com.pcloud.networking.client.Response;
import com.pcloud.networking.client.ResponseBody;
import com.pcloud.networking.client.ResponseBodyUtils;
import com.pcloud.networking.client.ResponseData;
import com.pcloud.networking.client.SelfEndingBytesReader;
import com.pcloud.networking.protocol.BytesWriter;
import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolResponseReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

class RealCall
implements Call {
    private static final int RESPONSE_LENGTH = 4;
    private final Request request;
    private final ExecutorService callExecutor;
    private final ConnectionProvider connectionProvider;
    private final List<RequestInterceptor> interceptors;
    private volatile boolean cancelled;
    private volatile boolean executed;
    private Connection connection;

    RealCall(Request request, ExecutorService callExecutor, List<RequestInterceptor> interceptors, ConnectionProvider connectionProvider) {
        this.request = request;
        this.callExecutor = callExecutor;
        this.connectionProvider = connectionProvider;
        this.interceptors = interceptors;
    }

    @Override
    public Response execute() throws IOException {
        this.checkAndMarkExecuted();
        return this.getResponse();
    }

    @Override
    public Response enqueueAndWait() throws IOException, InterruptedException {
        this.checkAndMarkExecuted();
        try {
            return this.callExecutor.submit(new Callable<Response>(){

                @Override
                public Response call() throws IOException {
                    return RealCall.this.getResponse();
                }
            }).get();
        }
        catch (ExecutionException e) {
            this.cancel();
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (CancellationException e) {
            this.cancel();
            throw new IOException(e);
        }
    }

    @Override
    public Response enqueueAndWait(long timeout, TimeUnit timeUnit) throws IOException, InterruptedException, TimeoutException {
        this.checkAndMarkExecuted();
        boolean success = false;
        try {
            Response response = this.callExecutor.submit(new Callable<Response>(){

                @Override
                public Response call() throws IOException {
                    return RealCall.this.getResponse();
                }
            }).get(timeout, timeUnit);
            success = true;
            Response response2 = response;
            return response2;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
        finally {
            if (!success) {
                this.cancel();
            }
        }
    }

    @Override
    public void enqueue(final Callback callback) {
        this.checkAndMarkExecuted();
        this.callExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!RealCall.this.isCancelled()) {
                    boolean callingCallback = false;
                    Response response = null;
                    boolean success = false;
                    try {
                        response = RealCall.this.getResponse();
                        callingCallback = true;
                        callback.onResponse(RealCall.this, response);
                        callingCallback = false;
                        success = true;
                    }
                    catch (IOException e) {
                        if (!callingCallback) {
                            callback.onFailure(RealCall.this, e);
                        }
                    }
                    finally {
                        if (!success) {
                            RealCall.this.cancel();
                            IOUtils.closeQuietly((Closeable)response);
                        }
                    }
                }
            }
        });
    }

    @Override
    public Request request() {
        return this.request;
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        if (!this.cancelled) {
            Connection connection;
            this.cancelled = true;
            RealCall realCall = this;
            synchronized (realCall) {
                connection = this.connection;
                this.connection = null;
            }
            IOUtils.closeQuietly((Closeable)connection);
        }
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public Call clone() {
        return new RealCall(this.request, this.callExecutor, this.interceptors, this.connectionProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndMarkExecuted() {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response getResponse() throws IOException {
        if (this.cancelled) {
            throw new IOException("Cancelled.");
        }
        Connection connection = this.request.endpoint() != null ? this.connectionProvider.obtainConnection(this.request.endpoint()) : this.connectionProvider.obtainConnection();
        RealCall realCall = this;
        synchronized (realCall) {
            this.connection = connection;
        }
        boolean success = false;
        try {
            BytesWriter writer = new BytesWriter(connection.sink());
            writer.beginRequest().writeMethodName(this.request.methodName());
            if (this.request.dataSource() != null) {
                writer.writeData(this.request.dataSource());
            }
            for (RequestInterceptor r : this.interceptors) {
                r.intercept(this.request, (ProtocolWriter)writer);
            }
            this.request.body().writeTo((ProtocolWriter)writer);
            writer.endRequest();
            connection.sink().flush();
            Response response = Response.create().request(this.request).responseBody(this.createResponseBody(connection)).build();
            success = true;
            Response response2 = response;
            return response2;
        }
        finally {
            if (!success) {
                IOUtils.closeQuietly((Closeable)connection);
            }
            RealCall realCall2 = this;
            synchronized (realCall2) {
                this.connection = null;
            }
        }
    }

    private ResponseBody createResponseBody(final Connection connection) throws IOException {
        long responseLength = IOUtils.peekNumberLe((BufferedSource)connection.source(), (int)4);
        AutoCloseSource responseParametersSource = new AutoCloseSource(connection, responseLength);
        BufferedSource source = Okio.buffer((Source)responseParametersSource);
        SelfEndingBytesReader reader = new SelfEndingBytesReader(source);
        reader.beginResponse();
        return new ResponseBody((ProtocolResponseReader)reader, responseLength, source){
            private final Endpoint endpoint;
            private ResponseData data;
            private FixedLengthSource dataSource;
            final /* synthetic */ ProtocolResponseReader val$reader;
            final /* synthetic */ long val$responseLength;
            final /* synthetic */ BufferedSource val$source;
            {
                this.val$reader = protocolResponseReader;
                this.val$responseLength = l;
                this.val$source = bufferedSource;
                this.endpoint = connection.endpoint();
            }

            @Override
            public ProtocolReader reader() {
                return this.val$reader;
            }

            @Override
            public long contentLength() {
                return this.val$responseLength;
            }

            @Override
            public Endpoint endpoint() {
                return this.endpoint;
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                ResponseBodyUtils.checkNotAlreadyRead(this);
                this.val$source.peek().readAll((Sink)sink);
                this.val$reader.beginObject();
                ResponseBodyUtils.skipRemainingValues(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ResponseData data() throws IOException {
                int scope = this.val$reader.currentScope();
                if (scope == -1) {
                    return null;
                }
                if (scope != 1) {
                    throw new IOException("Cannot access data content before the response body has been completely read.");
                }
                long dataLength = this.val$reader.dataContentLength();
                ProtocolResponseReader protocolResponseReader = this.val$reader;
                synchronized (protocolResponseReader) {
                    if (this.data == null) {
                        this.dataSource = new RecyclingFixedLengthSource(RealCall.this.connectionProvider, connection, dataLength);
                        this.data = new ResponseData(Okio.buffer((Source)this.dataSource), dataLength);
                    }
                }
                return this.data;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() {
                boolean responseReadFully;
                FixedLengthSource dataSource;
                int currentScope;
                ProtocolResponseReader protocolResponseReader = this.val$reader;
                synchronized (protocolResponseReader) {
                    currentScope = this.val$reader.currentScope();
                    dataSource = this.dataSource;
                }
                boolean bl = responseReadFully = currentScope == -1;
                if (responseReadFully && (dataSource == null || dataSource.bytesRemaining() == 0L)) {
                    RealCall.this.connectionProvider.recycleConnection(connection);
                } else {
                    IOUtils.closeQuietly((Closeable)connection);
                }
            }
        };
    }

    private static class AutoCloseSource
    extends FixedLengthSource {
        private final Connection connection;

        AutoCloseSource(Connection connection, long responseLength) throws IOException {
            super((Source)connection.source(), responseLength + 4L);
            this.connection = connection;
        }

        @Override
        protected void exhausted(boolean reuseSource) {
            if (!reuseSource) {
                this.connection.close();
            }
        }
    }

    private static class RecyclingFixedLengthSource
    extends FixedLengthSource {
        private final ConnectionProvider connectionPool;
        private final Connection connection;

        private RecyclingFixedLengthSource(ConnectionProvider pool, Connection connection, long contentLength) throws IOException {
            super((Source)connection.source(), contentLength);
            this.connection = connection;
            this.connectionPool = pool;
        }

        @Override
        protected void exhausted(boolean reuseSource) {
            if (reuseSource) {
                this.connectionPool.recycleConnection(this.connection);
            } else {
                IOUtils.closeQuietly((Closeable)this.connection);
            }
        }
    }
}

