/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.client;

import com.pcloud.networking.client.Connection;
import com.pcloud.networking.client.ConnectionPool;
import com.pcloud.networking.client.Connections;
import com.pcloud.networking.client.Endpoint;
import com.pcloud.networking.client.EndpointProvider;
import com.pcloud.networking.client.ErrorReportingConnection;
import com.pcloud.networking.client.RealConnection;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;

class ConnectionProvider {
    private final ConnectionPool connectionPool;
    private final EndpointProvider endpointProvider;
    private final SocketFactory socketFactory;
    private final SSLSocketFactory sslSocketFactory;
    private final HostnameVerifier hostnameVerifier;
    private final int connectTimeout;
    private final int readTimeout;
    private final int writeTimeout;
    private final boolean eagerlyCheckConnectivity;

    ConnectionProvider(ConnectionPool connectionPool, EndpointProvider endpointProvider, SocketFactory socketFactory, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier, int connectTimeout, int readTimeout, int writeTimeout, boolean eagerlyCheckConnectivity) {
        this.connectionPool = connectionPool;
        this.endpointProvider = endpointProvider;
        this.socketFactory = socketFactory;
        this.sslSocketFactory = sslSocketFactory;
        this.hostnameVerifier = hostnameVerifier;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.eagerlyCheckConnectivity = eagerlyCheckConnectivity;
    }

    Connection obtainConnection() throws IOException {
        return this.obtainConnection(this.endpointProvider.endpoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection obtainConnection(Endpoint endpoint) throws IOException {
        RealConnection cachedConnection;
        RealConnection result = null;
        while ((cachedConnection = this.connectionPool.get(endpoint)) != null) {
            if (cachedConnection.isHealthy(this.eagerlyCheckConnectivity)) {
                if (!(cachedConnection instanceof ErrorReportingConnection)) {
                    throw new IllegalStateException("Invalid cached connection type.");
                }
                result = (ErrorReportingConnection)cachedConnection;
                break;
            }
            cachedConnection.close(true);
        }
        if (result == null) {
            boolean connected = false;
            try {
                result = new ErrorReportingConnection(this.socketFactory, this.sslSocketFactory, this.hostnameVerifier, endpoint, Connections.CLEANUP_THREAD_EXECUTOR);
                ((ErrorReportingConnection)result).connect(this.connectTimeout, TimeUnit.MILLISECONDS);
                connected = true;
            }
            finally {
                if (!connected && result != null) {
                    result.close(true);
                }
            }
        }
        result.readTimeout(this.readTimeout, TimeUnit.MILLISECONDS);
        result.writeTimeout(this.writeTimeout, TimeUnit.MILLISECONDS);
        ((ErrorReportingConnection)result).endpointProvider(this.endpointProvider);
        return result;
    }

    void recycleConnection(Connection connection) {
        if (!(connection instanceof ErrorReportingConnection)) {
            throw new IllegalStateException("Cannot recycle an unknown connection.");
        }
        ((ErrorReportingConnection)connection).endpointProvider(null);
        this.connectionPool.recycle((RealConnection)connection);
    }
}

