/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api.adapters;

import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.Call;
import com.pcloud.networking.api.CallAdapter;
import com.pcloud.networking.api.MultiCall;
import com.pcloud.utils.Types;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import rx.Single;
import rx.SingleSubscriber;
import rx.functions.Action0;
import rx.subscriptions.Subscriptions;

public class RxSingleCallAdapter<T>
implements CallAdapter<T, Single<T>> {
    public static final CallAdapter.Factory FACTORY = new CallAdapter.Factory(){

        public CallAdapter<?, ?> get(ApiComposer apiComposer, Method method) {
            Type returnType = method.getGenericReturnType();
            Class rawType = Types.getRawType((Type)returnType);
            if (Single.class.equals((Object)rawType)) {
                Type observableType = 1.getParameterUpperBound((int)0, (Type)returnType);
                return new RxSingleCallAdapter(observableType);
            }
            return null;
        }
    };
    private final Type responseType;

    RxSingleCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Single<T> adapt(final Call<T> call) {
        return Single.create((Single.OnSubscribe)new Single.OnSubscribe<T>(){

            public void call(SingleSubscriber<? super T> singleSubscriber) {
                final Call callClone = call.clone();
                singleSubscriber.add(Subscriptions.create((Action0)new Action0(){

                    public void call() {
                        callClone.cancel();
                    }
                }));
                try {
                    singleSubscriber.onSuccess(callClone.execute());
                }
                catch (Throwable throwable) {
                    singleSubscriber.onError(throwable);
                }
            }
        });
    }

    public Single<T> adapt(MultiCall<?, T> call) {
        throw new IllegalArgumentException("Cannot convert a `" + call.getClass().getCanonicalName() + "` to a `" + Single.class.getCanonicalName() + "` ");
    }
}

