/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.api.adapters;

import com.pcloud.networking.api.ApiComposer;
import com.pcloud.networking.api.Call;
import com.pcloud.networking.api.CallAdapter;
import com.pcloud.networking.api.Interactor;
import com.pcloud.networking.api.MultiCall;
import com.pcloud.utils.Types;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import rx.Emitter;
import rx.Observable;
import rx.Observer;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;
import rx.functions.Func0;
import rx.observables.AsyncOnSubscribe;
import rx.observables.SyncOnSubscribe;

public class RxObservableCallAdapter<T>
implements CallAdapter<T, Observable<T>> {
    public static final CallAdapter.Factory FACTORY = new CallAdapter.Factory(){

        public CallAdapter<?, ?> get(ApiComposer apiComposer, Method method) {
            Type returnType = method.getGenericReturnType();
            Class rawType = Types.getRawType((Type)returnType);
            if (Observable.class.equals((Object)rawType)) {
                Type observableType = 1.getParameterUpperBound((int)0, (Type)returnType);
                return new RxObservableCallAdapter(observableType);
            }
            return null;
        }
    };
    private final Type responseType;

    RxObservableCallAdapter(Type responseType) {
        this.responseType = responseType;
    }

    public Type responseType() {
        return this.responseType;
    }

    public Observable<T> adapt(final Call<T> call) {
        return Observable.unsafeCreate((Observable.OnSubscribe)SyncOnSubscribe.createSingleState((Func0)new Func0<Call<T>>(){

            public Call<T> call() {
                return call.clone();
            }
        }, (Action2)new Action2<Call<T>, Observer<? super T>>(){

            public void call(Call<T> callClone, Observer<? super T> observer) {
                try {
                    observer.onNext(callClone.execute());
                    observer.onCompleted();
                }
                catch (Throwable throwable) {
                    observer.onError(throwable);
                }
            }
        }, (Action1)new Action1<Call<T>>(){

            public void call(Call<T> tCall) {
                tCall.cancel();
            }
        }));
    }

    public Observable<T> adapt(final MultiCall<?, T> call) {
        return Observable.create((AsyncOnSubscribe)AsyncOnSubscribe.createSingleState((Func0)new Func0<Interactor<T>>(){

            public Interactor<T> call() {
                return call.clone().start();
            }
        }, (Action3)new Action3<Interactor<T>, Long, Observer<Observable<? extends T>>>(){

            public void call(final Interactor<T> interactor, final Long requested, Observer<Observable<? extends T>> observableObserver) {
                if (!interactor.hasNextResponse()) {
                    observableObserver.onCompleted();
                } else {
                    observableObserver.onNext((Object)Observable.create((Action1)new Action1<Emitter<T>>(){

                        public void call(Emitter<T> emitter) {
                            try {
                                int submitted = interactor.submitRequests((int)Math.min(Integer.MAX_VALUE, requested));
                                for (int i = 0; i < submitted; ++i) {
                                    emitter.onNext(interactor.nextResponse());
                                }
                                emitter.onCompleted();
                            }
                            catch (Throwable e) {
                                emitter.onError(e);
                            }
                        }
                    }, (Emitter.BackpressureMode)Emitter.BackpressureMode.NONE));
                }
            }
        }, (Action1)new Action1<Interactor<T>>(){

            public void call(Interactor<T> interactor) {
                interactor.close();
            }
        }));
    }
}

