/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.protocol;

import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Source;

public abstract class DataSource {
    public static final DataSource EMPTY = new DataSource(){

        @Override
        public long contentLength() {
            return 0L;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
        }
    };

    public long contentLength() {
        return -1L;
    }

    public abstract void writeTo(BufferedSink var1) throws IOException;

    public static DataSource create(final ByteString data) {
        if (data == null) {
            throw new IllegalArgumentException("Data argument cannot be null.");
        }
        return new DataSource(){

            @Override
            public long contentLength() {
                return data.size();
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(data);
            }
        };
    }

    public static DataSource create(final byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Data argument cannot be null.");
        }
        return new DataSource(){

            @Override
            public long contentLength() {
                return data.length;
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(data);
            }
        };
    }

    public static DataSource create(final File file) {
        if (file == null) {
            throw new IllegalArgumentException("File argument cannot be null.");
        }
        return new DataSource(){

            @Override
            public long contentLength() {
                return file.length();
            }

            @Override
            public void writeTo(BufferedSink sink) throws IOException {
                BufferedSource source = null;
                try {
                    source = Okio.buffer((Source)Okio.source((File)file));
                    sink.writeAll((Source)source);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(source);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)source);
            }
        };
    }
}

