/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.protocol;

import java.util.Arrays;
import java.util.NoSuchElementException;

class IntStack {
    private static final int INITIAL_CAPACITY = 10;
    private int[] data;
    private int elementCount;

    IntStack() {
        this(10);
    }

    IntStack(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Capacity must be a positive number");
        }
        this.data = new int[initialCapacity];
        this.elementCount = 0;
    }

    IntStack(IntStack scopeStack) {
        this.data = Arrays.copyOf(scopeStack.data, scopeStack.data.length);
        this.elementCount = scopeStack.elementCount;
    }

    private void ensureCapacity(int minimumCapacity) {
        if (this.data.length < minimumCapacity) {
            int[] biggerArray = new int[minimumCapacity];
            System.arraycopy(this.data, 0, biggerArray, 0, this.elementCount);
            this.data = biggerArray;
        }
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public int peek() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.data[this.elementCount - 1];
    }

    public int pop() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.data[--this.elementCount];
    }

    public void push(int item) {
        if (this.elementCount == this.data.length) {
            int newCapacity = this.elementCount << 1;
            if (newCapacity < 0) {
                throw new IllegalStateException("Stack size too big.");
            }
            this.ensureCapacity(newCapacity);
        }
        this.data[this.elementCount++] = item;
    }

    public int size() {
        return this.elementCount;
    }
}

