/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.protocol;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ValueReader {
    public Object read(ProtocolReader reader) throws IOException {
        TypeToken token = reader.peek();
        switch (token) {
            case NUMBER: {
                return reader.readNumber();
            }
            case STRING: {
                return reader.readString();
            }
            case BOOLEAN: {
                return reader.readBoolean();
            }
            case BEGIN_ARRAY: {
                return this.readArray(reader);
            }
            case BEGIN_OBJECT: {
                return this.readObject(reader);
            }
        }
        throw new IOException("Unexpected token '" + token.toString() + "'.");
    }

    public Map<String, ?> readObject(ProtocolReader reader) throws IOException {
        reader.beginObject();
        HashMap<String, Object> values = new HashMap<String, Object>();
        while (reader.hasNext()) {
            values.put(reader.readString(), this.read(reader));
        }
        reader.endObject();
        return values;
    }

    public Object[] readArray(ProtocolReader reader) throws IOException {
        return this.readList(reader).toArray();
    }

    public List<?> readList(ProtocolReader reader) throws IOException {
        reader.beginArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.hasNext()) {
            list.add(this.read(reader));
        }
        reader.endArray();
        return list;
    }
}

