/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.protocol;

import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;

public abstract class DataSink {
    public abstract void readAll(BufferedSource var1) throws IOException;

    public static DataSink create(final File file) {
        if (file == null) {
            throw new IllegalArgumentException("File argument cannot be null.");
        }
        return new DataSink(){

            @Override
            public void readAll(BufferedSource source) throws IOException {
                BufferedSink sink = null;
                try {
                    sink = Okio.buffer((Sink)Okio.sink((File)file));
                    source.readAll((Sink)sink);
                    sink.flush();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(sink);
                    IOUtils.closeQuietly((Closeable)source);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)sink);
                IOUtils.closeQuietly((Closeable)source);
            }
        };
    }
}

