/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.protocol;

import com.pcloud.networking.protocol.IntStack;
import com.pcloud.networking.protocol.ProtocolResponseReader;
import com.pcloud.networking.protocol.SerializationException;
import com.pcloud.networking.protocol.TypeToken;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.util.Arrays;
import java.util.Locale;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

public class BytesReader
implements ProtocolResponseReader {
    private static final int OFFSET_EXISTING_STRING_CACHE = 3;
    private static final int OFFSET_NUMBER_NON_COMPRESSED = 7;
    private static final int OFFSET_NUMBER_COMPRESSED = 200;
    private static final int OFFSET_READ_STRING_COMPRESSED_EXISTING_VALUE = 150;
    private static final int OFFSET_READ_STRING_COMPRESSED = 100;
    private static final int TYPE_AGGREGATE_STRING = -2;
    private static final int TYPE_AGGREGATE_END_OBJECT = -6;
    private static final int TYPE_AGGREGATE_END_ARRAY = -5;
    private static final int TYPE_AGGREGATE_NUMBER = -4;
    private static final int TYPE_AGGREGATE_BOOLEAN = -3;
    private static final int NUMBER_SKIP = 6;
    private static final int DEFAULT_STRING_CACHE_SIZE = 50;
    private static final int SCOPE_STACK_INITIAL_CAPACITY = 5;
    private static final int HEX_255 = 255;
    private volatile int currentScope = -1;
    private int previousScope = -1;
    private IntStack scopeStack = new IntStack(5);
    private BufferedSource bufferedSource;
    private int lastStringId;
    private String[] stringCache;
    private volatile long dataLength = -1L;

    private BytesReader() {
    }

    public BytesReader(BufferedSource bufferedSource) {
        if (bufferedSource == null) {
            throw new IllegalArgumentException("Source argument cannot be null.");
        }
        this.bufferedSource = bufferedSource;
    }

    @Override
    public TypeToken peek() throws IOException {
        BytesReader.checkScopeIsAtLeast(this.currentScope, 2);
        return this.getToken(this.peekType());
    }

    @Override
    public long beginResponse() throws IOException {
        BytesReader.checkScope(this.currentScope, -1);
        this.pushScope(2);
        this.stringCache = new String[50];
        this.lastStringId = 0;
        return this.pullNumber(4);
    }

    @Override
    public boolean endResponse() throws IOException {
        boolean dataAvailable;
        BytesReader.checkScope(this.currentScope, 2);
        if (this.previousScope == -1) {
            while (this.hasNext()) {
                this.skipValue();
            }
        }
        this.popScope();
        this.stringCache = null;
        boolean bl = dataAvailable = this.dataLength != -1L;
        if (dataAvailable) {
            this.pushScope(1);
        }
        return dataAvailable;
    }

    @Override
    public void beginObject() throws IOException {
        BytesReader.checkScopeIsAtLeast(this.currentScope, 2);
        int type = this.pullType();
        if (type != 16 && (type != 17 || this.peekType() != 255)) {
            throw this.typeMismatchError(16, type);
        }
        this.pushScope(10);
    }

    @Override
    public void beginArray() throws IOException {
        BytesReader.checkScopeIsAtLeast(this.currentScope, 10);
        int type = this.pullType();
        if (type != 17) {
            throw this.typeMismatchError(17, type);
        }
        this.pushScope(20);
    }

    @Override
    public void endArray() throws IOException {
        BytesReader.checkScope(this.currentScope, 20);
        int type = this.pullType();
        if (type != 255) {
            throw this.typeMismatchError(-5, type);
        }
        this.popScope();
    }

    @Override
    public void endObject() throws IOException {
        BytesReader.checkScope(this.currentScope, 10);
        int type = this.pullType();
        if (type != 255) {
            throw this.typeMismatchError(-6, type);
        }
        this.popScope();
    }

    @Override
    public boolean readBoolean() throws IOException {
        BytesReader.checkScopeIsAtLeast(this.currentScope, 10);
        int type = this.pullType();
        if (type == 19) {
            return true;
        }
        if (type == 18) {
            return false;
        }
        throw this.typeMismatchError(-3, type);
    }

    @Override
    public String readString() throws IOException {
        BytesReader.checkScopeIsAtLeast(this.currentScope, 10);
        int type = this.pullType();
        if (type >= 0 && type <= 3) {
            long stringLength = this.pullNumber(type + 1);
            String value = this.bufferedSource.readUtf8(stringLength);
            this.cacheString(value);
            return value;
        }
        if (type >= 4 && type <= 7) {
            int cachedStringId = (int)this.pullNumber(type - 3);
            return this.stringCache[cachedStringId];
        }
        if (type >= 100 && type <= 149) {
            int stringLength = type - 100;
            String value = this.bufferedSource.readUtf8((long)stringLength);
            this.cacheString(value);
            return value;
        }
        if (type >= 150 && type <= 199) {
            return this.stringCache[type - 150];
        }
        throw this.typeMismatchError(-2, type);
    }

    private void cacheString(String string) {
        if (this.stringCache.length == this.lastStringId + 1) {
            int newCapacity = this.stringCache.length << 1;
            if (newCapacity < 0) {
                throw new IllegalStateException("String cache size too big.");
            }
            this.stringCache = Arrays.copyOf(this.stringCache, newCapacity);
        }
        this.stringCache[this.lastStringId++] = string;
    }

    @Override
    public long readNumber() throws IOException {
        BytesReader.checkScopeIsAtLeast(this.currentScope, 10);
        int type = this.pullType();
        if (type >= 8 && type <= 15) {
            return this.pullNumber(type - 7);
        }
        if (type >= 200 && type <= 219) {
            return type - 200;
        }
        throw this.typeMismatchError(-4, type);
    }

    @Override
    public boolean hasNext() throws IOException {
        return (this.currentScope != 2 || this.previousScope == -1) && this.peekType() != 255;
    }

    @Override
    public long dataContentLength() {
        BytesReader.checkScope(this.currentScope, 1);
        return this.dataLength;
    }

    @Override
    public void readData(OutputStream outputStream) throws IOException {
        this.readData(Okio.buffer((Sink)Okio.sink((OutputStream)outputStream)));
    }

    @Override
    public void readData(BufferedSink sink) throws IOException {
        if (this.currentScope != 1) {
            throw new IllegalStateException("Cannot read data, either the response is not read fully or no data is following.");
        }
        long length = this.dataLength;
        sink.write((Source)this.bufferedSource, length);
        this.dataLength = -1L;
        this.popScope();
    }

    @Override
    public ProtocolResponseReader newPeekingReader() {
        PeekingByteReader reader = new PeekingByteReader();
        reader.currentScope = this.currentScope;
        reader.previousScope = this.previousScope;
        reader.scopeStack = new IntStack(this.scopeStack);
        reader.bufferedSource = Okio.buffer((Source)this.bufferedSource.peek());
        reader.stringCache = this.stringCache;
        reader.dataLength = this.dataLength;
        reader.lastStringId = this.lastStringId;
        return reader;
    }

    @Override
    public void skipValue() throws IOException {
        BytesReader.checkScopeIsAtLeast(this.currentScope, 2);
        int type = this.peekType();
        if (type >= 8 && type <= 15) {
            this.bufferedSource.skip((long)(type - 6));
        } else if (type >= 200 && type <= 219) {
            this.bufferedSource.skip(1L);
        } else if (type >= 4 && type <= 7) {
            this.bufferedSource.skip((long)(type - 2));
        } else if (type >= 0 && type <= 3 || type >= 100 && type <= 199) {
            this.readString();
        } else if (type == 19 || type == 18) {
            this.bufferedSource.skip(1L);
        } else if (type == 16) {
            this.beginObject();
            while (this.hasNext()) {
                this.skipValue();
            }
            this.endObject();
        } else if (type == 17) {
            this.beginArray();
            while (this.hasNext()) {
                this.skipValue();
            }
            this.endArray();
        } else if (type == 20) {
            this.dataLength = this.pullNumber(8);
        } else if (type == 255) {
            int scope = this.currentScope();
            switch (scope) {
                case 10: {
                    this.endObject();
                    break;
                }
                default: {
                    this.endArray();
                    break;
                }
            }
        } else {
            throw new ProtocolException("Unknown type " + type);
        }
    }

    @Override
    public int currentScope() {
        return this.currentScope;
    }

    @Override
    public Timeout timeout() {
        return this.bufferedSource.timeout();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.bufferedSource);
    }

    private void pushScope(int newScope) {
        this.previousScope = this.currentScope;
        this.scopeStack.push(newScope);
        this.currentScope = newScope;
    }

    private void popScope() {
        if (this.currentScope != -1) {
            this.previousScope = this.scopeStack.pop();
            this.currentScope = this.scopeStack.isEmpty() ? -1 : this.scopeStack.peek();
        }
    }

    private int peekType() throws IOException {
        int type = (int)IOUtils.peekNumberLe((BufferedSource)this.bufferedSource, (int)1);
        if (type == 20) {
            this.dataLength = IOUtils.peekNumberLe((BufferedSource)this.bufferedSource, (int)1, (int)8);
            return 15;
        }
        return type;
    }

    private int pullType() throws IOException {
        int type = this.bufferedSource.readByte() & 0xFF;
        if (type == 20) {
            this.dataLength = IOUtils.peekNumberLe((BufferedSource)this.bufferedSource, (int)8);
            return 15;
        }
        return type;
    }

    private long pullNumber(int byteCount) throws IOException {
        return IOUtils.readNumberLe((BufferedSource)this.bufferedSource, (int)byteCount);
    }

    private SerializationException typeMismatchError(int expectedType, int actualType) {
        return new SerializationException("Expected '" + this.typeName(expectedType) + "', but was '" + this.typeName(actualType) + "'.");
    }

    private TypeToken getToken(int type) throws SerializationException {
        if (type >= 8 && type <= 15 || type >= 200 && type <= 219) {
            return TypeToken.NUMBER;
        }
        if (type >= 0 && type <= 3 || type >= 4 && type <= 7 || type >= 100 && type <= 199) {
            return TypeToken.STRING;
        }
        if (type == 16) {
            return TypeToken.BEGIN_OBJECT;
        }
        if (type == 17) {
            return TypeToken.BEGIN_ARRAY;
        }
        if (type >= 18 && type <= 19) {
            return TypeToken.BOOLEAN;
        }
        if (type == 255) {
            return this.currentScope == 10 ? TypeToken.END_OBJECT : TypeToken.END_ARRAY;
        }
        throw new SerializationException("Unknown type " + type);
    }

    private String typeName(int type) {
        TypeToken typeToken;
        switch (type) {
            case -4: {
                typeToken = TypeToken.NUMBER;
                break;
            }
            case -2: {
                typeToken = TypeToken.STRING;
                break;
            }
            case -3: {
                typeToken = TypeToken.BOOLEAN;
                break;
            }
            case -5: {
                typeToken = TypeToken.END_ARRAY;
                break;
            }
            case -6: {
                typeToken = TypeToken.END_OBJECT;
                break;
            }
            default: {
                try {
                    typeToken = this.getToken(type);
                    break;
                }
                catch (SerializationException e) {
                    return "(Unknown type " + type + ")";
                }
            }
        }
        return typeToken.toString().toUpperCase(Locale.ENGLISH);
    }

    private static void checkScope(int current, int expected) {
        if (current != expected) {
            throw new IllegalStateException(String.format("Expected to be called when scope is `%s`, current is `%s`.", BytesReader.scopeName(expected), BytesReader.scopeName(current)));
        }
    }

    private static void checkScopeIsAtLeast(int current, int expected) {
        if (current < expected) {
            throw new IllegalStateException(String.format("Expected to be called when scope is at least `%s`, current is `%s`.", BytesReader.scopeName(expected), BytesReader.scopeName(current)));
        }
    }

    private static String scopeName(int scope) {
        switch (scope) {
            case 2: {
                return "SCOPE_RESPONSE";
            }
            case 20: {
                return "SCOPE_ARRAY";
            }
            case 10: {
                return "SCOPE_OBJECT";
            }
            case 1: {
                return "SCOPE_DATA";
            }
            case -1: {
                return "SCOPE_NONE";
            }
        }
        return "<UNKNOWN>";
    }

    private static class PeekingByteReader
    extends BytesReader {
        private PeekingByteReader() {
        }

        @Override
        public ProtocolResponseReader newPeekingReader() {
            throw new IllegalStateException("Cannot call newPeekingReader(), this reader is already non-consuming.");
        }

        @Override
        public void readData(OutputStream outputStream) {
            throw new UnsupportedOperationException("Data cannot be peeked.");
        }

        @Override
        public void readData(BufferedSink sink) {
            throw new UnsupportedOperationException("Data cannot be peeked.");
        }

        @Override
        public void close() {
        }
    }
}

