/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.protocol;

import com.pcloud.networking.protocol.DataSource;
import com.pcloud.networking.protocol.ProtocolRequestWriter;
import com.pcloud.networking.protocol.SerializationException;
import com.pcloud.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.math.BigInteger;
import okio.Buffer;
import okio.BufferedSink;
import okio.Timeout;
import okio.Utf8;

public class BytesWriter
implements ProtocolRequestWriter {
    private static final int REQUEST_PARAM_TYPE_STRING = 0;
    private static final int REQUEST_PARAM_TYPE_NUMBER = 1;
    private static final int REQUEST_PARAM_TYPE_BOOLEAN = 2;
    private static final int REQUEST_PARAM_COUNT_LIMIT = 255;
    private static final int REQUEST_PARAM_NAME_LENGTH_LIMIT = 63;
    private static final int REQUEST_SIZE_LIMIT_BYTES = 65535;
    private static final int REQUEST_BINARY_DATA_FLAG_POSITION = 7;
    private static final int MAX_METHOD_LENGTH = 127;
    private static final int BITWISE_SHIFT_SIX = 6;
    private static final int DATA_LENGTH_SIZE = 8;
    private final BufferedSink sink;
    private final Buffer paramsBuffer;
    private DataSource dataSource;
    private String methodName;
    private boolean requestStarted;
    private int parameterCount;
    private String nextValueName;

    public BytesWriter(BufferedSink sink) {
        if (sink == null) {
            throw new IllegalArgumentException("'sink' argument cannot be null.");
        }
        this.sink = sink;
        this.paramsBuffer = new Buffer();
    }

    @Override
    public ProtocolRequestWriter beginRequest() throws IOException {
        if (this.requestStarted) {
            throw new IllegalStateException("beginRequest() has been already called.");
        }
        this.requestStarted = true;
        return this;
    }

    @Override
    public ProtocolRequestWriter writeMethodName(String name) throws IOException {
        this.checkRequestStarted();
        this.checkWriteValueFinished();
        if (name == null) {
            throw new IllegalArgumentException("'name' argument cannot be null.");
        }
        if (this.methodName != null) {
            throw new IllegalStateException("method() already called for the started request.");
        }
        this.methodName = name;
        return this;
    }

    @Override
    public ProtocolRequestWriter endRequest() throws IOException {
        long dataSourceLength;
        this.checkRequestStarted();
        this.checkWriteValueFinished();
        if (this.methodName == null) {
            throw new IllegalArgumentException("Cannot end request, writeMethodName() has not been called.");
        }
        int methodNameLength = (int)Utf8.size((String)this.methodName);
        if (methodNameLength > 127) {
            throw new SerializationException("Invalid method name '%s', value cannot be larger than 127 bytes in UTF-8 encoding.", this.methodName);
        }
        long l = dataSourceLength = this.dataSource != null ? this.dataSource.contentLength() : 0L;
        if (dataSourceLength < 0L) {
            throw new SerializationException("Unknown or invalid DataSource content length '%d'.", dataSourceLength);
        }
        boolean hasData = dataSourceLength > 0L;
        long requestSize = (long)((hasData ? 8 : 0) + 1 + 1 + methodNameLength) + this.paramsBuffer.size();
        if (requestSize > 65535L) {
            throw new SerializationException("The maximum allowed request size is 65535 bytes, current is " + requestSize + " bytes.");
        }
        if (hasData) {
            methodNameLength |= 0x80;
        }
        this.sink.writeShortLe((int)requestSize);
        this.sink.writeByte(methodNameLength);
        if (hasData) {
            this.sink.writeLongLe(dataSourceLength);
        }
        this.sink.writeUtf8(this.methodName);
        this.sink.writeByte(this.parameterCount);
        this.sink.write(this.paramsBuffer, this.paramsBuffer.size());
        if (hasData) {
            this.dataSource.writeTo(this.sink);
        }
        this.sink.emit();
        this.dataSource = null;
        this.methodName = null;
        this.requestStarted = false;
        this.parameterCount = 0;
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.sink.flush();
    }

    @Override
    public ProtocolRequestWriter writeData(DataSource source) throws IOException {
        this.checkRequestStarted();
        this.checkWriteValueFinished();
        if (this.dataSource != null) {
            throw new IllegalStateException("data() already called for current request.");
        }
        if (source == null) {
            throw new IllegalArgumentException("DataSource argument cannot be null.");
        }
        this.dataSource = source;
        return this;
    }

    @Override
    public ProtocolRequestWriter writeName(String name) throws IOException {
        this.checkRequestStarted();
        this.checkWriteValueFinished();
        if (name == null) {
            throw new IllegalArgumentException("Name parameter cannot be null.");
        }
        if (this.nextValueName != null) {
            throw new IllegalStateException("A previous writeName() was not matched with a writeValue() call.");
        }
        if (this.parameterCount >= 255) {
            throw new SerializationException("Request parameter count limit reached.");
        }
        this.nextValueName = name;
        ++this.parameterCount;
        return this;
    }

    private void writeNextValueTypeAndName(int type) throws SerializationException {
        int parameterNameLength = (int)Utf8.size((String)this.nextValueName);
        if (parameterNameLength > 63) {
            throw new SerializationException("Parameter name '%s' is too long.", this.nextValueName);
        }
        int encodedParamData = parameterNameLength | type << 6;
        this.paramsBuffer.writeByte(encodedParamData);
        this.paramsBuffer.writeUtf8(this.nextValueName);
        this.nextValueName = null;
    }

    @Override
    public ProtocolRequestWriter writeValue(Object value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Value argument cannot be null.");
        }
        Class<?> valueType = value.getClass();
        if (valueType == String.class) {
            this.writeValue((String)value);
        } else if (valueType == Long.class) {
            this.writeValue((Long)value);
        } else if (valueType == Integer.class) {
            this.writeValue(((Integer)value).intValue());
        } else if (valueType == Float.class) {
            this.writeValue(((Float)value).floatValue());
        } else if (valueType == Double.class) {
            this.writeValue((Double)value);
        } else if (valueType == Short.class) {
            this.writeValue(((Short)value).shortValue());
        } else if (valueType == Byte.class) {
            this.writeValue(((Byte)value).byteValue());
        } else if (valueType == Boolean.class) {
            this.writeValue((Boolean)value);
        } else if (valueType == Character.class) {
            this.writeValue(String.valueOf(value));
        } else if (valueType == BigInteger.class) {
            this.writeValue((BigInteger)value);
        } else {
            throw new IllegalArgumentException("Cannot serialize value of type '" + String.valueOf(valueType) + "'.");
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeValue(BigInteger value) throws IOException {
        if (value.bitLength() <= 64) {
            this.writeNextValueTypeAndName(1);
            if (value.bitLength() > 63) throw new ArithmeticException(String.valueOf(value) + " is out of long range");
            this.paramsBuffer.writeLongLe(value.longValue());
            return;
        } else {
            this.writeNextValueTypeAndName(0);
            this.writeString(value.toString());
        }
    }

    @Override
    public ProtocolRequestWriter writeValue(String value) throws IOException {
        this.checkWriteNameCalled();
        if (value == null) {
            throw new IllegalArgumentException("Value argument cannot be null.");
        }
        this.writeNextValueTypeAndName(0);
        this.writeString(value);
        return this;
    }

    private void writeString(String value) {
        this.paramsBuffer.writeIntLe((int)Utf8.size((String)value));
        this.paramsBuffer.writeUtf8(value);
    }

    @Override
    public ProtocolRequestWriter writeValue(long value) throws IOException {
        this.checkWriteNameCalled();
        if (value < 0L) {
            this.writeNextValueTypeAndName(0);
            this.writeString(String.valueOf(value));
        } else {
            this.writeNextValueTypeAndName(1);
            this.paramsBuffer.writeLongLe(value);
        }
        return this;
    }

    @Override
    public ProtocolRequestWriter writeValue(boolean value) throws IOException {
        this.checkWriteNameCalled();
        this.writeNextValueTypeAndName(2);
        this.paramsBuffer.writeByte(value ? 1 : 0);
        return this;
    }

    @Override
    public ProtocolRequestWriter writeValue(double value) throws IOException {
        this.checkWriteNameCalled();
        this.writeNextValueTypeAndName(0);
        this.writeString(String.valueOf(value));
        return this;
    }

    @Override
    public ProtocolRequestWriter writeValue(float value) throws IOException {
        this.checkWriteNameCalled();
        this.writeNextValueTypeAndName(0);
        this.writeString(String.valueOf(value));
        return this;
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.sink);
        IOUtils.closeQuietly((Closeable)this.paramsBuffer);
        this.dataSource = null;
    }

    private void checkRequestStarted() {
        if (!this.requestStarted) {
            throw new IllegalStateException("Call beginRequest() before calling this method.");
        }
    }

    private void checkWriteValueFinished() {
        if (this.nextValueName != null) {
            throw new IllegalStateException("Expected a call to one of the writeValue() methods.");
        }
    }

    private void checkWriteNameCalled() {
        if (this.nextValueName == null) {
            throw new IllegalStateException("Call writeName() before calling this method.");
        }
    }
}

