/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.serialization.ObjectPool;
import com.pcloud.networking.serialization.StringJoinerProtocolWriter;
import com.pcloud.networking.serialization.TypeAdapter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

class ArrayTypeAdapter
extends TypeAdapter<Object> {
    private final ObjectPool<StringJoinerProtocolWriter> joinerWriterPool = new ObjectPool(5);
    private Class<?> elementClass;
    private TypeAdapter elementAdapter;

    ArrayTypeAdapter(Class<?> elementClass, TypeAdapter elementAdapter) {
        this.elementClass = elementClass;
        this.elementAdapter = elementAdapter;
    }

    @Override
    public Object deserialize(ProtocolReader reader) throws IOException {
        ArrayList elements = new ArrayList();
        reader.beginArray();
        while (reader.hasNext()) {
            elements.add(this.elementAdapter.deserialize(reader));
        }
        reader.endArray();
        Object array = Array.newInstance(this.elementClass, elements.size());
        for (int i = 0; i < elements.size(); ++i) {
            Array.set(array, i, elements.get(i));
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ProtocolWriter writer, Object value) throws IOException {
        if (value != null) {
            int arrayLength = Array.getLength(value);
            if (arrayLength > 0) {
                StringJoinerProtocolWriter joinerWriter = this.joinerWriterPool.acquire();
                if (joinerWriter == null) {
                    joinerWriter = new StringJoinerProtocolWriter(",");
                }
                try {
                    for (int i = 0; i < arrayLength; ++i) {
                        this.elementAdapter.serialize(joinerWriter, Array.get(value, i));
                    }
                    writer.writeValue(joinerWriter.result());
                }
                finally {
                    joinerWriter.reset();
                    this.joinerWriterPool.recycle(joinerWriter);
                }
            } else {
                writer.writeValue("");
            }
        }
    }

    public String toString() {
        return "TypeAdapter[" + this.elementClass.getName() + "[]]";
    }
}

