/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.serialization.ArrayTypeAdapter;
import com.pcloud.networking.serialization.GuardedSerializationTypeAdapter;
import com.pcloud.networking.serialization.Transformer;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.networking.serialization.TypeAdapterFactory;
import com.pcloud.utils.Types;
import java.lang.reflect.Type;

class ArrayTypeAdapterFactory
implements TypeAdapterFactory {
    static final TypeAdapterFactory INSTANCE = new ArrayTypeAdapterFactory();

    private ArrayTypeAdapterFactory() {
    }

    @Override
    public TypeAdapter<?> create(Type type, Transformer transformer) {
        Type elementType = Types.arrayComponentType((Type)type);
        if (elementType != null) {
            Class elementClass = Types.getRawType((Type)elementType);
            TypeAdapter elementAdapter = transformer.getTypeAdapter(elementType);
            if (!elementClass.isPrimitive() || !elementClass.isEnum()) {
                elementAdapter = new GuardedSerializationTypeAdapter(elementAdapter);
            }
            return new ArrayTypeAdapter(elementClass, elementAdapter);
        }
        return null;
    }
}

