/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.serialization.ClassFactory;
import com.pcloud.networking.serialization.TypeAdapter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;

class ClassTypeAdapter<T>
extends TypeAdapter<T> {
    private final ClassFactory<T> classFactory;
    private final Map<String, Binding> nameToBindingMap;

    ClassTypeAdapter(ClassFactory<T> classFactory, Map<String, Binding> fieldsMap) {
        this.classFactory = classFactory;
        this.nameToBindingMap = fieldsMap;
    }

    @Override
    public T deserialize(ProtocolReader reader) throws IOException {
        T result;
        try {
            result = this.classFactory.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new RuntimeException(targetException);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                String name = reader.readString();
                Binding binding = this.nameToBindingMap.get(name);
                if (binding != null) {
                    binding.read(reader, result);
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return result;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    @Override
    public void serialize(ProtocolWriter writer, T value) throws IOException {
        try {
            for (Binding binding : this.nameToBindingMap.values()) {
                binding.write(writer, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        return "TypeAdapter[" + this.classFactory.getClass().getName() + "]";
    }

    static abstract class Binding {
        final String name;
        final Field field;

        Binding(String name, Field field) {
            this.name = name;
            this.field = field;
        }

        abstract void read(ProtocolReader var1, Object var2) throws IOException, IllegalAccessException;

        abstract void write(ProtocolWriter var1, Object var2) throws IllegalAccessException, IOException;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Binding)) {
                return false;
            }
            Binding binding = (Binding)o;
            return Objects.equals(this.name, binding.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

