/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.protocol.SerializationException;
import com.pcloud.networking.serialization.ClassFactory;
import com.pcloud.networking.serialization.ClassTypeAdapter;
import com.pcloud.networking.serialization.GuardedSerializationTypeAdapter;
import com.pcloud.networking.serialization.ParameterValue;
import com.pcloud.networking.serialization.Transformer;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.networking.serialization.TypeAdapterFactory;
import com.pcloud.utils.Types;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

class ClassTypeAdapterFactory
implements TypeAdapterFactory {
    static final TypeAdapterFactory INSTANCE = new ClassTypeAdapterFactory();

    private ClassTypeAdapterFactory() {
    }

    @Override
    public TypeAdapter<?> create(Type type, Transformer transformer) {
        Class rawType = Types.getRawType((Type)type);
        if (rawType.isInterface() || rawType.isEnum()) {
            return null;
        }
        if (this.isPlatformType(rawType) && !rawType.isPrimitive() && !rawType.isEnum()) {
            throw new IllegalArgumentException("Platform type '" + type + "' requires explicit TypeAdapter to be registered");
        }
        if (rawType.getEnclosingClass() != null && !Modifier.isStatic(rawType.getModifiers())) {
            if (rawType.getSimpleName().isEmpty()) {
                throw new IllegalArgumentException("Cannot serialize anonymous class " + rawType.getName());
            }
            throw new IllegalArgumentException("Cannot serialize non-static nested class " + rawType.getName());
        }
        if (Modifier.isAbstract(rawType.getModifiers())) {
            throw new IllegalArgumentException("Cannot serialize abstract class " + rawType.getName());
        }
        ClassFactory classFactory = ClassFactory.get(rawType);
        HashMap<String, ClassTypeAdapter.Binding> fields = new HashMap<String, ClassTypeAdapter.Binding>();
        Type t = type;
        while (t != Object.class) {
            this.createFieldBindings(transformer, t, fields);
            t = Types.getGenericSuperclass((Type)t);
        }
        return new ClassTypeAdapter(classFactory, fields);
    }

    private void createFieldBindings(Transformer transformer, Type type, Map<String, ClassTypeAdapter.Binding> fieldBindings) {
        Class rawType = Types.getRawType((Type)type);
        boolean platformType = this.isPlatformType(rawType);
        for (Field field : rawType.getDeclaredFields()) {
            ParameterValue paramAnnotation;
            if (!this.includeField(platformType, field.getModifiers()) || (paramAnnotation = field.getAnnotation(ParameterValue.class)) == null) continue;
            Type fieldType = Types.resolve((Type)type, (Class)rawType, (Type)field.getGenericType());
            field.setAccessible(true);
            String annotatedName = paramAnnotation.value();
            String name = annotatedName.equals(" _%DEFAULT") ? field.getName() : annotatedName;
            ClassTypeAdapter.Binding fieldBinding = ClassTypeAdapterFactory.createBindingForField(transformer, name, field, fieldType);
            ClassTypeAdapter.Binding existing = fieldBindings.put(name, fieldBinding);
            if (existing == null) continue;
            throw new IllegalArgumentException("Conflicting fields:\n    " + existing.field + "\n    " + fieldBinding.field);
        }
    }

    private static ClassTypeAdapter.Binding createPrimitiveBinding(String name, Field field, Class<?> fieldClass) {
        if (fieldClass == Long.TYPE) {
            return new LongBinding(name, field);
        }
        if (fieldClass == Integer.TYPE) {
            return new IntBinding(name, field);
        }
        if (fieldClass == Float.TYPE) {
            return new FloatBinding(name, field);
        }
        if (fieldClass == Double.TYPE) {
            return new DoubleBinding(name, field);
        }
        if (fieldClass == Short.TYPE) {
            return new ShortBinding(name, field);
        }
        if (fieldClass == Byte.TYPE) {
            return new ByteBinding(name, field);
        }
        if (fieldClass == Boolean.TYPE) {
            return new BooleanBinding(name, field);
        }
        if (fieldClass == Character.TYPE) {
            return new CharBinding(name, field);
        }
        throw new IllegalArgumentException("Cannot serialize value of type '" + fieldClass.getName() + "'.");
    }

    private static ClassTypeAdapter.Binding createBindingForField(Transformer transformer, String name, Field field, Type fieldType) {
        Class fieldClass = Types.getRawType((Type)fieldType);
        if (fieldClass.isPrimitive()) {
            return ClassTypeAdapterFactory.createPrimitiveBinding(name, field, fieldClass);
        }
        TypeAdapter adapter = transformer.getTypeAdapter(fieldType);
        if (!fieldClass.isPrimitive() || !fieldClass.isEnum()) {
            adapter = new GuardedSerializationTypeAdapter(adapter);
        }
        return new ObjectBinding(name, field, adapter);
    }

    private boolean isPlatformType(Class<?> rawType) {
        String name = rawType.getName();
        return name.startsWith("android.") || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("kotlin.") || name.startsWith("scala.") || name.startsWith("groovy.");
    }

    private boolean includeField(boolean platformType, int modifiers) {
        if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) {
            return false;
        }
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers) || !platformType;
    }

    private static class LongBinding
    extends ClassTypeAdapter.Binding {
        LongBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            this.field.setLong(target, reader.readNumber());
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            long fieldValue = this.field.getLong(target);
            writer.writeName(this.name);
            writer.writeValue(fieldValue);
        }
    }

    private static class IntBinding
    extends ClassTypeAdapter.Binding {
        IntBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            this.field.setInt(target, (int)reader.readNumber());
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            int fieldValue = this.field.getInt(target);
            writer.writeName(this.name);
            writer.writeValue((long)fieldValue);
        }
    }

    private static class FloatBinding
    extends ClassTypeAdapter.Binding {
        FloatBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            String numberString = reader.readString();
            try {
                this.field.setFloat(target, Float.parseFloat(numberString));
            }
            catch (NumberFormatException e) {
                throw new IOException("Failed to convert '" + numberString + "' to a Float", e);
            }
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            float fieldValue = this.field.getFloat(target);
            writer.writeName(this.name);
            writer.writeValue(fieldValue);
        }
    }

    private static class DoubleBinding
    extends ClassTypeAdapter.Binding {
        DoubleBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            String numberString = reader.readString();
            try {
                this.field.setDouble(target, Double.parseDouble(numberString));
            }
            catch (NumberFormatException e) {
                throw new IOException("Failed to convert '" + numberString + "' to a Float", e);
            }
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            double fieldValue = this.field.getDouble(target);
            writer.writeName(this.name);
            writer.writeValue(fieldValue);
        }
    }

    private static class ShortBinding
    extends ClassTypeAdapter.Binding {
        ShortBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            this.field.setShort(target, (short)reader.readNumber());
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            short fieldValue = this.field.getShort(target);
            writer.writeName(this.name);
            writer.writeValue((long)fieldValue);
        }
    }

    private static class CharBinding
    extends ClassTypeAdapter.Binding {
        CharBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            this.field.setChar(target, (char)reader.readNumber());
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            char fieldValue = this.field.getChar(target);
            writer.writeName(this.name);
            writer.writeValue((long)fieldValue);
        }
    }

    private static class ByteBinding
    extends ClassTypeAdapter.Binding {
        ByteBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            this.field.setByte(target, (byte)reader.readNumber());
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            byte fieldValue = this.field.getByte(target);
            writer.writeName(this.name);
            writer.writeValue((long)fieldValue);
        }
    }

    private static class BooleanBinding
    extends ClassTypeAdapter.Binding {
        BooleanBinding(String name, Field field) {
            super(name, field);
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            this.field.set(target, reader.readBoolean());
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            boolean fieldValue = this.field.getBoolean(target);
            writer.writeName(this.name);
            writer.writeValue(fieldValue);
        }
    }

    private static class ObjectBinding<T>
    extends ClassTypeAdapter.Binding {
        final TypeAdapter<T> adapter;

        ObjectBinding(String name, Field field, TypeAdapter<T> adapter) {
            super(name, field);
            this.adapter = adapter;
        }

        @Override
        void read(ProtocolReader reader, Object target) throws IOException, IllegalAccessException {
            try {
                T fieldValue = this.adapter.deserialize(reader);
                this.field.set(target, fieldValue);
            }
            catch (SerializationException e) {
                throw new SerializationException("Cannot deserialize field '" + this.field.getDeclaringClass().getName() + "." + this.field.getName() + "' of type '" + this.field.getType().getName() + "'.", (Throwable)e);
            }
        }

        @Override
        void write(ProtocolWriter writer, Object target) throws IllegalAccessException, IOException {
            Object fieldValue = this.field.get(target);
            if (fieldValue != null) {
                writer.writeName(this.name);
                this.adapter.serialize(writer, fieldValue);
            }
        }
    }
}

