/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.serialization.ObjectPool;
import com.pcloud.networking.serialization.StringJoinerProtocolWriter;
import com.pcloud.networking.serialization.TypeAdapter;
import java.io.IOException;
import java.util.Collection;

abstract class CollectionTypeAdapter<T extends Collection<E>, E>
extends TypeAdapter<T> {
    private TypeAdapter<E> elementAdapter;
    private final ObjectPool<StringJoinerProtocolWriter> joinerWriterPool = new ObjectPool(5);

    CollectionTypeAdapter(TypeAdapter<E> elementAdapter) {
        this.elementAdapter = elementAdapter;
    }

    @Override
    public T deserialize(ProtocolReader reader) throws IOException {
        T container = this.instantiateCollection();
        reader.beginArray();
        while (reader.hasNext()) {
            container.add(this.elementAdapter.deserialize(reader));
        }
        reader.endArray();
        return container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ProtocolWriter writer, T value) throws IOException {
        if (value != null) {
            if (!value.isEmpty()) {
                StringJoinerProtocolWriter joinWriter = this.joinerWriterPool.acquire();
                if (joinWriter == null) {
                    joinWriter = new StringJoinerProtocolWriter(",");
                }
                try {
                    for (Object item : value) {
                        this.elementAdapter.serialize(joinWriter, item);
                    }
                    writer.writeValue(joinWriter.result());
                }
                finally {
                    joinWriter.reset();
                    this.joinerWriterPool.recycle(joinWriter);
                }
            } else {
                writer.writeValue("");
            }
        }
    }

    protected abstract T instantiateCollection();
}

