/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.serialization.CollectionTypeAdapter;
import com.pcloud.networking.serialization.GuardedSerializationTypeAdapter;
import com.pcloud.networking.serialization.MapTypeAdapter;
import com.pcloud.networking.serialization.Transformer;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.networking.serialization.TypeAdapterFactory;
import com.pcloud.utils.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

class CollectionsTypeAdapterFactory
implements TypeAdapterFactory {
    static final TypeAdapterFactory INSTANCE = new CollectionsTypeAdapterFactory();

    private CollectionsTypeAdapterFactory() {
    }

    @Override
    public TypeAdapter<?> create(Type type, Transformer transformer) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        Class rawType = Types.getRawType((Type)type);
        if (rawType.isAssignableFrom(List.class)) {
            return CollectionsTypeAdapterFactory.newArrayListAdapter(type, transformer);
        }
        if (rawType == Set.class) {
            return CollectionsTypeAdapterFactory.newLinkedHashSetAdapter(type, transformer);
        }
        if (rawType == Map.class) {
            return CollectionsTypeAdapterFactory.newMapAdapter((ParameterizedType)type, transformer);
        }
        return null;
    }

    private static <T> TypeAdapter<Collection<T>> newArrayListAdapter(Type type, Transformer transformer) {
        Type elementType = Types.collectionElementType((Type)type, Collection.class);
        TypeAdapter<T> elementAdapter = CollectionsTypeAdapterFactory.getTypeAdapter(transformer, elementType);
        return new CollectionTypeAdapter<Collection<T>, T>(elementAdapter){

            @Override
            protected Collection<T> instantiateCollection() {
                return new ArrayList();
            }
        };
    }

    private static <T> TypeAdapter<Set<T>> newLinkedHashSetAdapter(Type type, Transformer transformer) {
        Type elementType = Types.collectionElementType((Type)type, Collection.class);
        TypeAdapter<T> elementAdapter = CollectionsTypeAdapterFactory.getTypeAdapter(transformer, elementType);
        return new CollectionTypeAdapter<Set<T>, T>(elementAdapter){

            @Override
            protected Set<T> instantiateCollection() {
                return new LinkedHashSet();
            }
        };
    }

    private static <K, V> TypeAdapter<Map<K, V>> newMapAdapter(ParameterizedType type, Transformer transformer) {
        Type keyElementType = Types.getParameterUpperBound((int)0, (ParameterizedType)type);
        Type valueElementType = Types.getParameterUpperBound((int)1, (ParameterizedType)type);
        TypeAdapter keyAdapter = transformer.getTypeAdapter(keyElementType);
        TypeAdapter valueAdapter = transformer.getTypeAdapter(valueElementType);
        return new MapTypeAdapter<K, V>(keyAdapter, valueAdapter){

            @Override
            protected Map<K, V> instantiateCollection() {
                return new TreeMap();
            }
        };
    }

    private static <T> TypeAdapter<T> getTypeAdapter(Transformer transformer, Type type) {
        TypeAdapter typeAdapter = transformer.getTypeAdapter(type);
        Class rawType = Types.getRawType((Type)type);
        if (!rawType.isPrimitive() || !rawType.isEnum()) {
            typeAdapter = new GuardedSerializationTypeAdapter(typeAdapter);
        }
        return typeAdapter;
    }
}

