/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.protocol.SerializationException;
import com.pcloud.networking.protocol.TypeToken;
import com.pcloud.networking.serialization.ParameterValue;
import com.pcloud.networking.serialization.TypeAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class EnumTypeAdapter<T extends Enum<T>>
extends TypeAdapter<T> {
    private final Class<T> enumType;
    private final Map<String, T> nameToConstantMap;
    private final Map<T, String> constantToNameMap;

    EnumTypeAdapter(Class<T> enumType) {
        this.enumType = enumType;
        try {
            Enum[] constants = (Enum[])enumType.getEnumConstants();
            this.nameToConstantMap = new HashMap<String, T>(constants.length);
            this.constantToNameMap = new HashMap<T, String>(constants.length);
            for (int i = 0; i < constants.length; ++i) {
                String name;
                Enum constant = constants[i];
                ParameterValue annotation = enumType.getField(constant.name()).getAnnotation(ParameterValue.class);
                String string = name = annotation != null && !annotation.value().equals(" _%DEFAULT") ? annotation.value() : constant.name();
                if (this.nameToConstantMap.put(name, constant) != null) {
                    throw new IllegalStateException("Cannot create a " + TypeAdapter.class.getSimpleName() + " for enumeration '" + enumType.getName() + "'. Duplicate serialization name '" + name + "'.");
                }
                this.constantToNameMap.put(constant, name);
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError("Missing field in " + enumType.getName(), e);
        }
    }

    @Override
    public T deserialize(ProtocolReader reader) throws IOException {
        String name;
        TypeToken typeToken = reader.peek();
        switch (typeToken) {
            case NUMBER: {
                name = String.valueOf(reader.readNumber());
                break;
            }
            case STRING: {
                name = reader.readString();
                break;
            }
            default: {
                throw new SerializationException("Cannot deserialize '" + this.enumType.getName() + "':Only " + TypeToken.STRING + " and " + TypeToken.NUMBER + " types are allowed, but was " + typeToken + ".");
            }
        }
        Enum enumConstant = (Enum)this.nameToConstantMap.get(name);
        if (enumConstant != null) {
            return (T)enumConstant;
        }
        throw new SerializationException("Cannot deserialize '" + this.enumType.getName() + "':\nExpected one of " + this.nameToConstantMap.keySet() + " but was '" + name + "'.");
    }

    @Override
    public void serialize(ProtocolWriter writer, T value) throws IOException {
        if (value != null) {
            String name = this.constantToNameMap.get(value);
            writer.writeValue(name);
        }
    }

    public String toString() {
        return "TypeAdapter[" + this.enumType.getName() + "]";
    }
}

