/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.protocol.SerializationException;
import com.pcloud.networking.serialization.ObjectPool;
import com.pcloud.networking.serialization.TypeAdapter;
import java.io.IOException;

public class GuardedSerializationTypeAdapter<T>
extends TypeAdapter<T> {
    private static final int GUARD_POOL_SIZE = 5;
    private TypeAdapter<T> delegate;
    private ObjectPool<SingleValueProtocolWriter> guardedWriterObjectPool = new ObjectPool(5);

    public GuardedSerializationTypeAdapter(TypeAdapter<T> delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("TypeAdapter argument cannot be null.");
        }
        this.delegate = delegate;
    }

    @Override
    public T deserialize(ProtocolReader reader) throws IOException {
        return this.delegate.deserialize(reader);
    }

    @Override
    public void serialize(ProtocolWriter writer, T value) throws IOException {
        SingleValueProtocolWriter singleValueProtocolWriter = this.guardedWriterObjectPool.acquire();
        if (singleValueProtocolWriter == null) {
            singleValueProtocolWriter = new SingleValueProtocolWriter();
        }
        singleValueProtocolWriter.guard(writer);
        try {
            this.delegate.serialize(singleValueProtocolWriter, value);
        }
        catch (NotSerializedToAValueException e) {
            throw new SerializationException(this.delegate.getClass() + " does not serialize \"" + value.getClass() + "\" to a single value", (Throwable)((Object)e));
        }
        finally {
            singleValueProtocolWriter.reset();
            this.guardedWriterObjectPool.recycle(singleValueProtocolWriter);
        }
    }

    private static class SingleValueProtocolWriter
    implements ProtocolWriter {
        private ProtocolWriter delegate;

        private SingleValueProtocolWriter() {
        }

        void guard(ProtocolWriter writer) {
            this.delegate = writer;
        }

        void reset() {
            this.delegate = null;
        }

        public ProtocolWriter writeName(String name) throws IOException {
            throw new NotSerializedToAValueException();
        }

        public ProtocolWriter writeValue(Object value) throws IOException {
            this.delegate.writeValue(value);
            return this;
        }

        public ProtocolWriter writeValue(String value) throws IOException {
            this.delegate.writeValue(value);
            return this;
        }

        public ProtocolWriter writeValue(double value) throws IOException {
            this.delegate.writeValue(value);
            return this;
        }

        public ProtocolWriter writeValue(float value) throws IOException {
            this.delegate.writeValue(value);
            return this;
        }

        public ProtocolWriter writeValue(long value) throws IOException {
            this.delegate.writeValue(value);
            return this;
        }

        public ProtocolWriter writeValue(boolean value) throws IOException {
            this.delegate.writeValue(value);
            return this;
        }

        public void close() {
            this.delegate.close();
        }
    }

    private static class NotSerializedToAValueException
    extends SerializationException {
        private NotSerializedToAValueException() {
            super("Object must serialize to a single value.");
        }
    }
}

