/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.networking.serialization.UnserializableTypeException;
import java.io.IOException;
import java.util.Map;

abstract class MapTypeAdapter<K, V>
extends TypeAdapter<Map<K, V>> {
    private TypeAdapter<K> keyAdapter;
    private TypeAdapter<V> valueAdapter;

    MapTypeAdapter(TypeAdapter<K> keyAdapter, TypeAdapter<V> valueAdapter) {
        this.keyAdapter = keyAdapter;
        this.valueAdapter = valueAdapter;
    }

    @Override
    public Map<K, V> deserialize(ProtocolReader reader) throws IOException {
        Map<K, V> container = this.instantiateCollection();
        reader.beginObject();
        while (reader.hasNext()) {
            container.put(this.keyAdapter.deserialize(reader), this.valueAdapter.deserialize(reader));
        }
        reader.endObject();
        return container;
    }

    @Override
    public void serialize(ProtocolWriter writer, Map<K, V> value) throws IOException {
        throw new UnserializableTypeException(value.getClass());
    }

    protected abstract Map<K, V> instantiateCollection();
}

