/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

class ObjectPool<T> {
    private final Object[] pool;
    private int mPoolSize;

    ObjectPool(int maxPoolSize) {
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("The max pool size must be > 0");
        }
        this.pool = new Object[maxPoolSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T acquire() {
        Object[] objectArray = this.pool;
        synchronized (this.pool) {
            if (this.mPoolSize > 0) {
                int lastPooledIndex = this.mPoolSize - 1;
                Object instance = this.pool[lastPooledIndex];
                this.pool[lastPooledIndex] = null;
                --this.mPoolSize;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (T)instance;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recycle(T instance) {
        Object[] objectArray = this.pool;
        synchronized (this.pool) {
            if (this.mPoolSize < this.pool.length) {
                this.pool[this.mPoolSize] = instance;
                ++this.mPoolSize;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }
}

