/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolReader;
import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.protocol.SerializationException;
import com.pcloud.networking.protocol.TypeToken;
import com.pcloud.networking.serialization.EnumTypeAdapter;
import com.pcloud.networking.serialization.Transformer;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.networking.serialization.TypeAdapterFactory;
import com.pcloud.utils.Types;
import java.io.IOException;
import java.lang.reflect.Type;

class PrimitiveTypesAdapterFactory
implements TypeAdapterFactory {
    static final TypeAdapter<String> STRING_ADAPTER = new TypeAdapter<String>(){

        @Override
        public String deserialize(ProtocolReader reader) throws IOException {
            return reader.readString();
        }

        @Override
        public void serialize(ProtocolWriter writer, String value) throws IOException {
            if (value != null) {
                writer.writeValue(value);
            }
        }
    };
    static final TypeAdapter<Boolean> BOOLEAN_ADAPTER = new TypeAdapter<Boolean>(){

        @Override
        public Boolean deserialize(ProtocolReader reader) throws IOException {
            return reader.readBoolean();
        }

        @Override
        public void serialize(ProtocolWriter writer, Boolean value) throws IOException {
            writer.writeValue(value.booleanValue());
        }
    };
    static final TypeAdapter<Integer> INTEGER_ADAPTER = new TypeAdapter<Integer>(){

        @Override
        public Integer deserialize(ProtocolReader reader) throws IOException {
            return (int)reader.readNumber();
        }

        @Override
        public void serialize(ProtocolWriter writer, Integer value) throws IOException {
            if (value != null) {
                writer.writeValue((long)value.intValue());
            }
        }
    };
    static final TypeAdapter<Long> LONG_ADAPTER = new TypeAdapter<Long>(){

        @Override
        public Long deserialize(ProtocolReader reader) throws IOException {
            return reader.readNumber();
        }

        @Override
        public void serialize(ProtocolWriter writer, Long value) throws IOException {
            if (value != null) {
                writer.writeValue(value.longValue());
            }
        }
    };
    static final TypeAdapter<Double> DOUBLE_ADAPTER = new TypeAdapter<Double>(){

        @Override
        public Double deserialize(ProtocolReader reader) throws IOException {
            String numberString = reader.readString();
            try {
                return Double.parseDouble(numberString);
            }
            catch (NumberFormatException e) {
                throw new IOException("Failed to convert '" + numberString + "' to a Double", e);
            }
        }

        @Override
        public void serialize(ProtocolWriter writer, Double value) throws IOException {
            if (value != null) {
                writer.writeValue(value.doubleValue());
            }
        }
    };
    static final TypeAdapter<Float> FLOAT_ADAPTER = new TypeAdapter<Float>(){

        @Override
        public Float deserialize(ProtocolReader reader) throws IOException {
            String numberString = reader.readString();
            try {
                return Float.valueOf(Float.parseFloat(numberString));
            }
            catch (NumberFormatException e) {
                throw new IOException("Failed to convert '" + numberString + "' to a Float", e);
            }
        }

        @Override
        public void serialize(ProtocolWriter writer, Float value) throws IOException {
            if (value != null) {
                writer.writeValue(value.floatValue());
            }
        }
    };
    static final TypeAdapter<Short> SHORT_ADAPTER = new TypeAdapter<Short>(){

        @Override
        public Short deserialize(ProtocolReader reader) throws IOException {
            return (short)reader.readNumber();
        }

        @Override
        public void serialize(ProtocolWriter writer, Short value) throws IOException {
            if (value != null) {
                writer.writeValue((long)value.shortValue());
            }
        }
    };
    static final TypeAdapter<Byte> BYTE_ADAPTER = new TypeAdapter<Byte>(){

        @Override
        public Byte deserialize(ProtocolReader reader) throws IOException {
            return (byte)reader.readNumber();
        }

        @Override
        public void serialize(ProtocolWriter writer, Byte value) throws IOException {
            if (value != null) {
                writer.writeValue((long)value.byteValue());
            }
        }
    };
    static final TypeAdapter<Character> CHAR_ADAPTER = new TypeAdapter<Character>(){

        @Override
        public Character deserialize(ProtocolReader reader) throws IOException {
            String value = reader.readString();
            if (value.length() != 1) {
                throw new SerializationException("Cannot deserialize %s with value '%s' to a char.", new Object[]{TypeToken.STRING, value});
            }
            return Character.valueOf(value.charAt(0));
        }

        @Override
        public void serialize(ProtocolWriter writer, Character value) throws IOException {
            if (value != null) {
                writer.writeValue(String.valueOf(value.charValue()));
            }
        }
    };
    static final TypeAdapterFactory INSTANCE = new PrimitiveTypesAdapterFactory();

    private PrimitiveTypesAdapterFactory() {
    }

    @Override
    public TypeAdapter<?> create(Type type, Transformer transformer) {
        if (type == String.class) {
            return STRING_ADAPTER;
        }
        if (type == Long.TYPE || type == Long.class) {
            return LONG_ADAPTER;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return BOOLEAN_ADAPTER;
        }
        if (type == Double.TYPE || type == Double.class) {
            return DOUBLE_ADAPTER;
        }
        if (type == Float.TYPE || type == Float.class) {
            return FLOAT_ADAPTER;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return INTEGER_ADAPTER;
        }
        if (type == Short.TYPE || type == Short.class) {
            return SHORT_ADAPTER;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return BYTE_ADAPTER;
        }
        if (type == Character.TYPE || type == Character.class) {
            return CHAR_ADAPTER;
        }
        Class rawType = Types.getRawType((Type)type);
        if (rawType.isEnum()) {
            return new EnumTypeAdapter(rawType);
        }
        return null;
    }
}

