/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.protocol.ProtocolWriter;
import com.pcloud.networking.protocol.SerializationException;
import java.io.IOException;

class StringJoinerProtocolWriter
implements ProtocolWriter {
    private StringBuilder builder;
    private final String delimiter;
    private int valueCount;

    StringJoinerProtocolWriter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.result() + "]";
    }

    public String result() {
        return this.builder != null ? this.builder.toString() : "";
    }

    public void reset() {
        this.valueCount = 0;
        if (this.builder != null) {
            this.builder.setLength(0);
        }
    }

    public ProtocolWriter writeName(String name) throws IOException {
        throw new SerializationException("Object must serialize to a single value.");
    }

    public ProtocolWriter writeValue(Object value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Value argument cannot be null");
        }
        if (!value.getClass().isPrimitive()) {
            throw new IllegalArgumentException("Cannot serialize value of type '" + value.getClass() + "'.");
        }
        return this.writeValue(String.valueOf(value));
    }

    public ProtocolWriter writeValue(String value) throws IOException {
        if (value == null) {
            throw new IllegalArgumentException("Value argument cannot be null");
        }
        if (this.builder == null) {
            this.builder = new StringBuilder();
        }
        if (this.valueCount > 0) {
            this.builder.append(this.delimiter);
        }
        this.builder.append(value);
        ++this.valueCount;
        return this;
    }

    public ProtocolWriter writeValue(double value) throws IOException {
        return this.writeValue(String.valueOf(value));
    }

    public ProtocolWriter writeValue(float value) throws IOException {
        return this.writeValue(String.valueOf(value));
    }

    public ProtocolWriter writeValue(long value) throws IOException {
        return this.writeValue(String.valueOf(value));
    }

    public ProtocolWriter writeValue(boolean value) throws IOException {
        return this.writeValue(String.valueOf(value));
    }

    public void close() {
    }
}

