/*
 * Decompiled with CFR 0.152.
 */
package com.pcloud.networking.serialization;

import com.pcloud.networking.serialization.ArrayTypeAdapterFactory;
import com.pcloud.networking.serialization.ClassTypeAdapterFactory;
import com.pcloud.networking.serialization.CollectionsTypeAdapterFactory;
import com.pcloud.networking.serialization.PrimitiveTypesAdapterFactory;
import com.pcloud.networking.serialization.StubTypeAdapter;
import com.pcloud.networking.serialization.TypeAdapter;
import com.pcloud.networking.serialization.TypeAdapterFactory;
import com.pcloud.networking.serialization.TypeAliasTypeAdapterFactory;
import com.pcloud.networking.serialization.WrapperTypeAdapterFactory;
import com.pcloud.utils.Types;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Transformer {
    private static final Collection<TypeAdapterFactory> DEFAULT_FACTORIES = new ArrayList<TypeAdapterFactory>(4);
    private static final int DEFAULT_FACTORIES_LIST_CAPACITY = 4;
    private final List<TypeAdapterFactory> adapterFactories;
    private final Map<Type, TypeAdapter<?>> typeToAdapterMap = new LinkedHashMap();
    private final ThreadLocal<List<StubTypeAdapter<?>>> pendingAdapterRef = new ThreadLocal();

    public static Builder create() {
        return new Builder();
    }

    private Transformer(Builder builder) {
        this.adapterFactories = new ArrayList<TypeAdapterFactory>();
        this.adapterFactories.addAll(builder.factories);
        this.adapterFactories.addAll(DEFAULT_FACTORIES);
    }

    public <T> TypeAdapter<T> getTypeAdapter(Class<T> type) {
        return this.getTypeAdapter((Type)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypeAdapter<T> getTypeAdapter(Type type) {
        type = Types.canonicalize((Type)type);
        Map<Type, TypeAdapter<?>> map = this.typeToAdapterMap;
        synchronized (map) {
            TypeAdapter<?> result = this.typeToAdapterMap.get(type);
            if (result != null) {
                return result;
            }
        }
        List<StubTypeAdapter<?>> pendingAdapters = this.pendingAdapterRef.get();
        if (pendingAdapters != null) {
            for (StubTypeAdapter stubTypeAdapter : pendingAdapters) {
                if (!stubTypeAdapter.cacheKey.equals(type)) continue;
                return stubTypeAdapter;
            }
        } else {
            pendingAdapters = new ArrayList();
            this.pendingAdapterRef.set(pendingAdapters);
        }
        StubTypeAdapter adapterStub = new StubTypeAdapter(type);
        pendingAdapters.add(adapterStub);
        try {
            for (TypeAdapterFactory factory : this.adapterFactories) {
                TypeAdapter<?> result = factory.create(type, this);
                if (result == null) continue;
                adapterStub.setDelegate(result);
                Object object = this.typeToAdapterMap;
                synchronized (object) {
                    this.typeToAdapterMap.put(type, result);
                }
                object = result;
                return object;
            }
        }
        finally {
            pendingAdapters.remove(pendingAdapters.size() - 1);
            if (pendingAdapters.isEmpty()) {
                this.pendingAdapterRef.remove();
            }
        }
        throw new IllegalStateException("Cannot create an adapter for type '" + type + "'.");
    }

    public Builder newBuilder() {
        ArrayList<TypeAdapterFactory> customFactories = new ArrayList<TypeAdapterFactory>(this.adapterFactories);
        customFactories.removeAll(DEFAULT_FACTORIES);
        return new Builder(customFactories);
    }

    static {
        DEFAULT_FACTORIES.add(PrimitiveTypesAdapterFactory.INSTANCE);
        DEFAULT_FACTORIES.add(CollectionsTypeAdapterFactory.INSTANCE);
        DEFAULT_FACTORIES.add(ArrayTypeAdapterFactory.INSTANCE);
        DEFAULT_FACTORIES.add(ClassTypeAdapterFactory.INSTANCE);
    }

    public static class Builder {
        private List<TypeAdapterFactory> factories;

        private Builder() {
            this.factories = new ArrayList<TypeAdapterFactory>();
        }

        private Builder(List<TypeAdapterFactory> factories) {
            this.factories = new ArrayList<TypeAdapterFactory>(factories);
        }

        public <T> Builder addTypeAdapter(Type type, TypeAdapter<T> adapter) {
            this.factories.add(new WrapperTypeAdapterFactory(type, adapter));
            return this;
        }

        public Builder addTypeAdapterFactory(TypeAdapterFactory adapterFactory) {
            if (adapterFactory == null) {
                throw new IllegalArgumentException("TypeAdapterFactory cannot be null.");
            }
            this.factories.add(adapterFactory);
            return this;
        }

        public Builder addTypeAlias(Type target, Type alias) {
            this.factories.add(new TypeAliasTypeAdapterFactory(target, alias));
            return this;
        }

        public Transformer build() {
            return new Transformer(this);
        }
    }
}

