/*
 * Decompiled with CFR 0.152.
 */
package com.phaxio.restclient.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;

public class RestResponse {
    private HttpURLConnection conn;
    private int status = 0;
    private String content;
    private Exception exception;
    private JsonNode jsonNode;
    private ObjectMapper objectMapper;

    public void setHttpURLConnection(HttpURLConnection httpConnection) {
        this.conn = httpConnection;
    }

    public String getContentType() {
        return this.conn.getHeaderField("Content-Type");
    }

    public int getStatusCode() throws IOException {
        if (this.status == 0) {
            this.status = this.conn.getResponseCode();
        }
        return this.status;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public String getContent() throws IOException {
        if (this.content == null) {
            this.content = Joiner.on((String)"\n").join((Iterable)IOUtils.readLines((InputStream)this.getInputStream(), (Charset)Charset.forName("UTF-8")));
        }
        return this.content;
    }

    public byte[] getRawBytes() throws IOException {
        return IOUtils.toByteArray((InputStream)this.getInputStream());
    }

    private InputStream getInputStream() throws IOException {
        return this.getStatusCode() == 200 || this.getStatusCode() == 201 ? this.conn.getInputStream() : this.conn.getErrorStream();
    }

    public JsonNode toJson() throws IOException {
        if (this.jsonNode == null) {
            this.jsonNode = this.getMapper().readTree(this.getContent());
        }
        return this.jsonNode;
    }

    public ObjectMapper getMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
        }
        return this.objectMapper;
    }
}

