/*
 * Decompiled with CFR 0.152.
 */
package com.powerupsoftwareengineering.java.immutable.web.model.translator;

import com.powerup.value.verification.util.StringVerificationUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TimeTranslator {
    public static final String DEFAULT_TIMEZONE = "UTC";
    private static final Logger logger = LoggerFactory.getLogger(TimeTranslator.class);

    private TimeTranslator() {
    }

    public static ZonedDateTime zonedDateTimeFromXml(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar != null) {
            return xmlGregorianCalendar.toGregorianCalendar().toZonedDateTime();
        }
        return null;
    }

    public static XMLGregorianCalendar zonedDateTimeToXml(ZonedDateTime zonedDateTime) {
        if (zonedDateTime != null) {
            GregorianCalendar gregorianCalendar = GregorianCalendar.from(zonedDateTime);
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (DatatypeConfigurationException ex) {
                logger.error("Unable to convert zoned date time", (Throwable)ex);
            }
        }
        return null;
    }

    public static LocalDateTime localDateTimeFromXml(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar != null) {
            return xmlGregorianCalendar.toGregorianCalendar().toZonedDateTime().toInstant().atZone(ZoneId.of(DEFAULT_TIMEZONE)).toLocalDateTime();
        }
        return null;
    }

    public static XMLGregorianCalendar localDateTimeToXml(LocalDateTime localDateTime) {
        if (localDateTime != null) {
            GregorianCalendar gregorianCalendar = GregorianCalendar.from(ZonedDateTime.of(localDateTime, ZoneId.of(DEFAULT_TIMEZONE)));
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (DatatypeConfigurationException ex) {
                logger.error("Unable to convert local date time", (Throwable)ex);
            }
        }
        return null;
    }

    public static LocalDate localDateFromXml(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar != null) {
            return xmlGregorianCalendar.toGregorianCalendar().toZonedDateTime().toInstant().atZone(ZoneId.of(DEFAULT_TIMEZONE)).toLocalDate();
        }
        return null;
    }

    public static XMLGregorianCalendar localDateToXml(LocalDate localDate) {
        if (localDate != null) {
            GregorianCalendar gregorianCalendar = GregorianCalendar.from(ZonedDateTime.of(localDate, LocalTime.MIDNIGHT, ZoneId.of(DEFAULT_TIMEZONE)));
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (DatatypeConfigurationException ex) {
                logger.error("Unable to convert local date", (Throwable)ex);
            }
        }
        return null;
    }

    public static LocalTime localTimeFromXml(XMLGregorianCalendar xmlGregorianCalendar) {
        if (xmlGregorianCalendar != null) {
            return xmlGregorianCalendar.toGregorianCalendar().toZonedDateTime().toInstant().atZone(ZoneId.of(DEFAULT_TIMEZONE)).toLocalTime();
        }
        return null;
    }

    public static XMLGregorianCalendar localTimeToXml(LocalTime localTime) {
        if (localTime != null) {
            GregorianCalendar gregorianCalendar = GregorianCalendar.from(ZonedDateTime.of(LocalDate.now(), localTime, ZoneId.of(DEFAULT_TIMEZONE)));
            try {
                return DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
            }
            catch (DatatypeConfigurationException ex) {
                logger.error("Unable to convert local time", (Throwable)ex);
            }
        }
        return null;
    }

    public static java.time.Duration durationFromXml(Duration jaxbDuration) {
        if (jaxbDuration == null) {
            return null;
        }
        return java.time.Duration.parse(jaxbDuration.toString());
    }

    public static Duration durationToXml(java.time.Duration duration) {
        if (duration != null) {
            try {
                return DatatypeFactory.newInstance().newDuration(duration.toString());
            }
            catch (DatatypeConfigurationException ex) {
                logger.error("Unable to convert duration", (Throwable)ex);
            }
        }
        return null;
    }

    public static Month monthFromXml(String month) {
        if (StringVerificationUtil.isNotEmpty((String)month)) {
            return Month.valueOf(month.toUpperCase());
        }
        return null;
    }

    public static String monthToXml(Month month) {
        if (month != null) {
            return StringUtils.capitalize((String)month.toString().toLowerCase());
        }
        return null;
    }
}

