/*
 * Decompiled with CFR 0.152.
 */
package com.qencode.api.java.client.classes;

import com.qencode.api.java.client.QencodeApiClient;
import com.qencode.api.java.client.QencodeException;
import com.qencode.api.java.client.classes.CustomTranscodingParams;
import com.qencode.api.java.client.classes.StitchVideoItem;
import com.qencode.api.java.client.classes.TranscodingTaskStatus;
import com.qencode.api.java.client.response.StartEncodeResponse;
import com.qencode.api.java.client.response.StatusResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TranscodingTask {
    private QencodeApiClient api;
    private String taskToken;
    private String statusUrl;
    private String transcodingProfiles;
    private String uri;
    private List<StitchVideoItem> stitchVideoItems;
    private String transferMethod;
    private double duration;
    private double startTime;
    private String payload;
    private Map<String, String> outputPathVariables;
    private TranscodingTaskStatus lastStatus;

    public String getTaskToken() {
        return this.taskToken;
    }

    public String getStatusUrl() {
        return this.statusUrl;
    }

    public String getTranscodingProfiles() {
        return this.transcodingProfiles;
    }

    public void setTranscodingProfiles(String transcodingProfiles) {
        this.transcodingProfiles = transcodingProfiles;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public StitchVideoItem addStitchVideoItem(String url) {
        StitchVideoItem item = new StitchVideoItem();
        if (this.stitchVideoItems == null) {
            this.stitchVideoItems = new ArrayList<StitchVideoItem>();
        }
        this.stitchVideoItems.add(item);
        item.setUrl(url);
        return item;
    }

    public String getTransferMethod() {
        return this.transferMethod;
    }

    public void setTransferMethod(String transferMethod) {
        this.transferMethod = transferMethod;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double value) {
        this.duration = value;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double value) {
        this.startTime = value;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public Map<String, String> getOutputPathVariables() {
        return this.outputPathVariables;
    }

    public void setOutputPathVariables(Map<String, String> outputPathVariables) {
        this.outputPathVariables = outputPathVariables;
    }

    public TranscodingTaskStatus getLastStatus() {
        return this.lastStatus;
    }

    public TranscodingTask(QencodeApiClient api, String taskToken) {
        this.api = api;
        this.taskToken = taskToken;
        this.statusUrl = null;
    }

    public StartEncodeResponse start() throws IOException, QencodeException {
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.stitchVideoItems != null && this.stitchVideoItems.size() > 0) {
            params.put("stitch", this.api.getMapper().writeValueAsString(this.stitchVideoItems));
        } else {
            params.put("uri", this.uri);
        }
        params.put("profiles", this.transcodingProfiles);
        if (this.transferMethod != null) {
            params.put("transfer_method", this.transferMethod);
        }
        if (this.outputPathVariables != null) {
            params.put("output_path_variables", this.api.getMapper().writeValueAsString(this.outputPathVariables));
        }
        return this._do_request("start_encode", params);
    }

    public StartEncodeResponse startCustom(CustomTranscodingParams taskParams) throws IOException, QencodeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", "{\"query\": " + this.api.getMapper().writeValueAsString((Object)taskParams) + "}");
        return this._do_request("start_encode2", params);
    }

    private StartEncodeResponse _do_request(String methodName, Map<String, String> params) throws UnsupportedEncodingException, QencodeException {
        StartEncodeResponse response;
        params.put("task_token", this.taskToken);
        if (this.payload != null) {
            params.put("payload", this.payload);
        }
        if (this.startTime > 0.0) {
            params.put("start_time", String.format(Locale.ROOT, "%.4f", this.startTime));
        }
        if (this.duration > 0.0) {
            params.put("duration", String.format(Locale.ROOT, "%.4f", this.duration));
        }
        String responseStr = this.api.Request(methodName, params);
        try {
            response = (StartEncodeResponse)this.api.getMapper().readValue(responseStr, StartEncodeResponse.class);
        }
        catch (Exception e) {
            throw new QencodeException("Unable to deserialize StartEncodeResponse as JSON", e);
        }
        this.statusUrl = response.getStatusUrl();
        return response;
    }

    public TranscodingTaskStatus getStatus() throws UnsupportedEncodingException, QencodeException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("task_tokens[]", this.taskToken);
        String responseStr = this.api.Request(this.statusUrl, params);
        StatusResponse response = null;
        try {
            response = (StatusResponse)this.api.getMapper().readValue(responseStr, StatusResponse.class);
        }
        catch (Exception e) {
            throw new QencodeException("Unable to deserialize StartEncodeResponse as JSON", e);
        }
        Map<String, TranscodingTaskStatus> statuses = response.getStatuses();
        this.lastStatus = statuses.get(this.taskToken);
        if (this.lastStatus != null) {
            this.statusUrl = this.lastStatus.getStatusUrl();
        }
        return this.lastStatus;
    }
}

