/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.leftvalues.BasicLeftValue;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.CommandAnalyzer;
import com.scriptbasic.interfaces.Expression;
import com.scriptbasic.interfaces.ExpressionList;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LeftValue;
import com.scriptbasic.interfaces.LeftValueList;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.interfaces.NestedStructure;
import com.scriptbasic.interfaces.NestedStructureHouseKeeper;
import com.scriptbasic.syntax.AbstractAnalyzer;
import com.scriptbasic.utility.FactoryUtility;
import com.scriptbasic.utility.SyntaxExceptionUtility;

public abstract class AbstractCommandAnalyzer
extends AbstractAnalyzer<Command>
implements CommandAnalyzer {
    private Factory factory;

    @Override
    public Factory getFactory() {
        return this.factory;
    }

    @Override
    public void setFactory(Factory factory) {
        this.factory = factory;
    }

    protected abstract String getName();

    protected static boolean equal(LeftValue a, LeftValue b) {
        if (a == b || a != null && a.equals(b)) {
            return true;
        }
        if (a instanceof BasicLeftValue && b instanceof BasicLeftValue) {
            BasicLeftValue aBasic = (BasicLeftValue)a;
            BasicLeftValue bBasic = (BasicLeftValue)b;
            if (aBasic.hasModifiers() || bBasic.hasModifiers()) {
                return false;
            }
            return aBasic.getIdentifier() != null && aBasic.getIdentifier().equals(bBasic.getIdentifier());
        }
        return false;
    }

    protected LeftValueList analyzeLeftValueList() throws AnalysisException {
        return (LeftValueList)FactoryUtility.getLeftValueListAnalyzer(this.getFactory()).analyze();
    }

    protected LeftValueList analyzeSimpleLeftValueList() throws AnalysisException {
        return (LeftValueList)FactoryUtility.getSimpleLeftValueListAnalyzer(this.getFactory()).analyze();
    }

    protected LeftValue analyzeSimpleLeftValue() throws AnalysisException {
        return (LeftValue)FactoryUtility.getSimpleLeftValueAnalyzer(this.getFactory()).analyze();
    }

    protected Expression analyzeExpression() throws AnalysisException {
        return FactoryUtility.getExpressionAnalyzer(this.getFactory()).analyze();
    }

    protected ExpressionList analyzeExpressionList() throws AnalysisException {
        return (ExpressionList)FactoryUtility.getExpressionListAnalyzer(this.getFactory()).analyze();
    }

    protected void pushNode(NestedStructure node) {
        NestedStructureHouseKeeper nshk = FactoryUtility.getNestedStructureHouseKeeper(this.getFactory());
        nshk.push(node);
    }

    protected void assertKeyWord(String keyword) throws AnalysisException {
        if (!this.isKeyWord(keyword)) {
            LexicalElement lexicalElement = FactoryUtility.getLexicalAnalyzer(this.getFactory()).peek();
            throw new GenericSyntaxException("There is no '" + keyword + "' after the '" + this.getName() + "'", lexicalElement, null);
        }
        FactoryUtility.getLexicalAnalyzer(this.getFactory()).get();
    }

    protected boolean isKeyWord(String keyword) throws AnalysisException {
        LexicalElement lexicalElement = FactoryUtility.getLexicalAnalyzer(this.getFactory()).peek();
        return lexicalElement != null && lexicalElement.isSymbol(keyword) != false;
    }

    protected void consumeEndOfLine() throws AnalysisException {
        LexicalElement le = FactoryUtility.getLexicalAnalyzer(this.factory).get();
        if (le != null && !le.isLineTerminator().booleanValue()) {
            SyntaxExceptionUtility.throwSyntaxException("There are extra characters following the expression after the '" + this.getName() + "' keyword", le);
        }
    }
}

