/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.log;

import com.scriptbasic.log.Logger;
import java.util.HashMap;
import java.util.Map;

public class LoggerFactory {
    private static final Map<Class<?>, Logger> loggers = new HashMap();

    public static synchronized Logger getLogger() {
        Logger logger;
        Class<?> klass = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass();
        if (loggers.containsKey(klass)) {
            logger = loggers.get(klass);
        } else {
            logger = new Logger(System.LoggerFinder.getLoggerFinder().getLogger(klass.getName(), klass.getModule()));
            loggers.put(klass, logger);
        }
        return logger;
    }

    public static synchronized Logger getBasicLogger() {
        Logger logger;
        Class<?> klass = ((StackWalker.StackFrame)StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(stream -> stream.filter(frame -> frame.getDeclaringClass().getModule().equals(LoggerFactory.class.getModule())).findFirst()).get()).getDeclaringClass();
        if (loggers.containsKey(klass)) {
            logger = loggers.get(klass);
        } else {
            logger = new Logger(System.LoggerFinder.getLoggerFinder().getLogger("BASIC", klass.getModule()));
            loggers.put(klass, logger);
        }
        return logger;
    }
}

