/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.utils;

import com.securenative.configurations.SecureNativeOptions;
import com.securenative.exceptions.SecureNativeSDKException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Formatter;
import javafx.util.Pair;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.digest.DigestUtils;

public class Utils {
    public static String COOKIE_NAME = "_sn";
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA512";
    private static final int AES_KEY_SIZE = 32;
    private static final String[] ipHeaders = new String[]{"x-forwarded-for", "x-client-ip", "x-real-ip", "x-forwarded", "x-cluster-client-ip", "forwarded-for", "forwarded", "via"};
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static String toHexString(byte[] bytes) {
        Formatter formatter = new Formatter();
        for (byte b : bytes) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private static String calculateRFC2104HMAC(String data, String key) throws SecureNativeSDKException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            return Utils.toHexString(mac.doFinal(data.getBytes()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new SecureNativeSDKException("failed calculating hmac");
        }
    }

    private static String calculateSignature(String payload, String apikey) {
        if (Utils.isNullOrEmpty(payload)) {
            return null;
        }
        try {
            return Utils.calculateRFC2104HMAC(payload, apikey);
        }
        catch (SecureNativeSDKException e) {
            return null;
        }
    }

    public static boolean isVerifiedSnRequest(String payload, String headerSignature, String apiKey) {
        String signed = Utils.calculateSignature(payload, apiKey);
        if (Utils.isNullOrEmpty(signed) || Utils.isNullOrEmpty(headerSignature)) {
            return false;
        }
        return headerSignature.equals(signed);
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static String decrypt(String s, String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NumberFormatException {
        if (s == null || s.length() == 0) {
            return s;
        }
        byte[] cipherText = Utils.hexToByteArray(s);
        SecretKeySpec skeySpec = new SecretKeySpec(key.substring(0, 32).getBytes(StandardCharsets.UTF_8), "AES");
        byte[] ivBytes = Arrays.copyOfRange(cipherText, 0, 16);
        cipherText = Arrays.copyOfRange(cipherText, 16, cipherText.length);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        IvParameterSpec IVspec = new IvParameterSpec(ivBytes);
        cipher.init(2, (Key)skeySpec, IVspec);
        return new String(cipher.doFinal(cipherText), StandardCharsets.UTF_8).trim();
    }

    private static byte[] hexToByteArray(String s) throws NumberFormatException {
        byte[] retValue = null;
        if (s != null && s.length() != 0) {
            retValue = new byte[s.length() / 2];
            for (int i = 0; i < retValue.length; ++i) {
                retValue[i] = (byte)Integer.parseInt(s.substring(2 * i, 2 * i + 2), 16);
            }
        }
        return retValue;
    }

    private static String byteArrayToHex(byte[] byteArray) {
        StringBuffer hexBuffer = new StringBuffer(byteArray.length * 2);
        for (byte b : byteArray) {
            for (int j = 1; j >= 0; --j) {
                hexBuffer.append(HEX[b >> j * 4 & 0xF]);
            }
        }
        return hexBuffer.toString();
    }

    public static String encrypt(String text, String key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecureRandom secureRandom = new SecureRandom();
        byte[] ivBytes = new byte[16];
        secureRandom.nextBytes(ivBytes);
        IvParameterSpec IVspec = new IvParameterSpec(ivBytes);
        SecretKeySpec skeySpec = new SecretKeySpec(key.substring(0, 32).getBytes(StandardCharsets.UTF_8), "AES");
        byte[] source = text.getBytes(StandardCharsets.UTF_8);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, (Key)skeySpec, IVspec);
        int mod = source.length % 16;
        if (mod != 0) {
            text = String.format(text + "%" + (16 - mod) + "s", " ");
        }
        return Utils.byteArrayToHex(cipher.doFinal(Utils.addAll(ivBytes, text.getBytes(StandardCharsets.UTF_8)))).trim();
    }

    private static byte[] addAll(byte[] array1, byte[] array2) {
        byte[] joinedArray = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    /*
     * Exception decompiling
     */
    public static int versionCompare(String str1, String str2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[WHILELOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isValidPublicIp(String ip) {
        Inet4Address address;
        try {
            address = (Inet4Address)InetAddress.getByName(ip);
        }
        catch (UnknownHostException exception) {
            return false;
        }
        return !address.isSiteLocalAddress() && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }

    public static String cookieIdFromRequest(ServletRequest request, SecureNativeOptions options) {
        Cookie[] cookies;
        if (request == null) {
            return "";
        }
        String cookieName = COOKIE_NAME;
        if (options.getCookieName() != null && !options.getCookieName().equals("")) {
            cookieName = options.getCookieName();
        }
        HttpServletRequest req = (HttpServletRequest)request;
        for (Cookie cookie : cookies = req.getCookies()) {
            if (!cookie.getName().equals(cookieName)) continue;
            return cookie.getValue();
        }
        return "";
    }

    public static String secureHeaderFromRequest(ServletRequest request) {
        if (request == null) {
            return "";
        }
        HttpServletRequest req = (HttpServletRequest)request;
        String secHeader = req.getHeader("x-securenative");
        if (secHeader != null) {
            return secHeader;
        }
        return "";
    }

    public static String clientIpFromRequest(ServletRequest request) {
        if (request == null) {
            return "";
        }
        HttpServletRequest req = (HttpServletRequest)request;
        String bestCandidate = "";
        for (String ipHeader : ipHeaders) {
            String ip;
            if (req.getHeader(ipHeader) == null || !Utils.isValidPublicIp(ip = req.getHeader(ipHeader))) continue;
            bestCandidate = ip;
        }
        return bestCandidate;
    }

    public static String remoteIpFromRequest(ServletRequest request) {
        HttpServletRequest req = (HttpServletRequest)request;
        return req.getRemoteAddr();
    }

    public static String userAgentFromRequest(ServletRequest request) {
        if (request == null) {
            return "";
        }
        HttpServletRequest req = (HttpServletRequest)request;
        return req.getHeader("user-agent");
    }

    public static String calculateHash(String str) {
        return DigestUtils.sha256Hex((String)str);
    }

    public static Pair<Long, String> getProcessInfo() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        Pair pair = new Pair((Object)0L, (Object)"");
        if (processName != null && processName.length() > 0) {
            try {
                String[] processTokens = processName.split("@");
                pair = new Pair((Object)Long.parseLong(processTokens[0]), (Object)processTokens[1]);
            }
            catch (Exception e) {
                return pair;
            }
        }
        return pair;
    }

    public static String generateTimestamp() {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
    }
}

