/*
 * Decompiled with CFR 0.152.
 */
package com.securenative.config;

import com.securenative.config.SecureNativeOptions;
import com.securenative.enums.FailoverStrategy;

public class SecureNativeConfigurationBuilder {
    private String apiKey;
    private String apiUrl;
    private int interval;
    private int maxEvents;
    private int timeout;
    private Boolean autoSend;
    private Boolean disable;
    private String logLevel;
    private FailoverStrategy failoverStrategy;

    private SecureNativeConfigurationBuilder() {
    }

    public static SecureNativeConfigurationBuilder defaultConfigBuilder() {
        return new SecureNativeConfigurationBuilder().withApiKey(null).withApiUrl("https://api.securenative.com/collector/api/v1").withInterval(1000).withTimeout(1500).withMaxEvents(1000).withAutoSend(true).withDisable(false).withLogLevel("fatal").withFailoverStrategy(FailoverStrategy.FAIL_OPEN);
    }

    public SecureNativeConfigurationBuilder withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    public SecureNativeConfigurationBuilder withApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
        return this;
    }

    public SecureNativeConfigurationBuilder withInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public SecureNativeConfigurationBuilder withMaxEvents(int maxEvents) {
        this.maxEvents = maxEvents;
        return this;
    }

    public SecureNativeConfigurationBuilder withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public SecureNativeConfigurationBuilder withAutoSend(Boolean autoSend) {
        this.autoSend = autoSend;
        return this;
    }

    public SecureNativeConfigurationBuilder withDisable(Boolean disable) {
        this.disable = disable;
        return this;
    }

    public SecureNativeConfigurationBuilder withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public SecureNativeConfigurationBuilder withFailoverStrategy(FailoverStrategy failoverStrategy) {
        this.failoverStrategy = failoverStrategy;
        return this;
    }

    public SecureNativeOptions build() {
        return new SecureNativeOptions(this.apiKey, this.apiUrl, this.interval, this.maxEvents, this.timeout, this.autoSend, this.disable, this.logLevel, this.failoverStrategy);
    }
}

