/*
 * Decompiled with CFR 0.152.
 */
package com.sendgrid;

import com.sendgrid.HttpDeleteWithBody;
import com.sendgrid.Request;
import com.sendgrid.Response;
import com.sendgrid.SendGridResponseHandler;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Client
implements Closeable {
    private CloseableHttpClient httpClient;
    private Boolean test;
    private boolean createdHttpClient;

    public Client() {
        this.httpClient = HttpClients.createDefault();
        this.test = false;
        this.createdHttpClient = true;
    }

    public Client(CloseableHttpClient httpClient) {
        this(httpClient, false);
    }

    public Client(Boolean test) {
        this(HttpClients.createDefault(), test);
    }

    public Client(CloseableHttpClient httpClient, Boolean test) {
        this.httpClient = httpClient;
        this.test = test;
        this.createdHttpClient = true;
    }

    public URI buildUri(String baseUri, String endpoint, Map<String, String> queryParams) throws URISyntaxException {
        URIBuilder builder = new URIBuilder();
        URI uri = null;
        if (this.test.booleanValue()) {
            builder.setScheme("http");
        } else {
            builder.setScheme("https");
        }
        builder.setHost(baseUri);
        builder.setPath(endpoint);
        if (queryParams != null) {
            String multiValueDelimiter = "&";
            for (Map.Entry<String, String> entry : queryParams.entrySet()) {
                String value = entry.getValue();
                if (value.indexOf(multiValueDelimiter) != -1) {
                    List<String> values = Arrays.asList(value.split(multiValueDelimiter));
                    for (String val : values) {
                        builder.addParameter(entry.getKey(), val);
                    }
                    continue;
                }
                builder.setParameter(entry.getKey(), entry.getValue());
            }
        }
        uri = builder.build();
        return uri;
    }

    public Response getResponse(CloseableHttpResponse response) throws IOException {
        SendGridResponseHandler handler = new SendGridResponseHandler();
        String responseBody = (String)handler.handleResponse((HttpResponse)response);
        int statusCode = response.getStatusLine().getStatusCode();
        Header[] headers = response.getAllHeaders();
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (Header h : headers) {
            responseHeaders.put(h.getName(), h.getValue());
        }
        return new Response(statusCode, responseBody, responseHeaders);
    }

    public Response get(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpGet httpGet = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpGet = new HttpGet(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpGet.setHeader(entry.getKey(), entry.getValue());
            }
        }
        return this.executeApiCall((HttpRequestBase)httpGet);
    }

    public Response post(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpPost httpPost = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpPost = new HttpPost(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        this.writeContentTypeIfNeeded(request, (HttpMessage)httpPost);
        return this.executeApiCall((HttpRequestBase)httpPost);
    }

    public Response patch(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpPatch httpPatch = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpPatch = new HttpPatch(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpPatch.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPatch.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        this.writeContentTypeIfNeeded(request, (HttpMessage)httpPatch);
        return this.executeApiCall((HttpRequestBase)httpPatch);
    }

    public Response put(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpPut httpPut = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpPut = new HttpPut(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpPut.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpPut.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        this.writeContentTypeIfNeeded(request, (HttpMessage)httpPut);
        return this.executeApiCall((HttpRequestBase)httpPut);
    }

    public Response delete(Request request) throws URISyntaxException, IOException {
        URI uri = null;
        HttpDeleteWithBody httpDelete = null;
        uri = this.buildUri(request.getBaseUri(), request.getEndpoint(), request.getQueryParams());
        httpDelete = new HttpDeleteWithBody(uri.toString());
        if (request.getHeaders() != null) {
            for (Map.Entry<String, String> entry : request.getHeaders().entrySet()) {
                httpDelete.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpDelete.setEntity((HttpEntity)new StringEntity(request.getBody(), Charset.forName("UTF-8")));
        this.writeContentTypeIfNeeded(request, (HttpMessage)httpDelete);
        return this.executeApiCall((HttpRequestBase)httpDelete);
    }

    private void writeContentTypeIfNeeded(Request request, HttpMessage httpMessage) {
        if (!"".equals(request.getBody())) {
            httpMessage.setHeader("Content-Type", "application/json");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Response executeApiCall(HttpRequestBase httpPost) throws IOException {
        Response response;
        CloseableHttpResponse serverResponse = this.httpClient.execute((HttpUriRequest)httpPost);
        try {
            response = this.getResponse(serverResponse);
        }
        catch (Throwable throwable) {
            try {
                serverResponse.close();
                throw throwable;
            }
            catch (ClientProtocolException e) {
                throw new IOException(e.getMessage());
            }
        }
        serverResponse.close();
        return response;
    }

    public Response api(Request request) throws IOException {
        try {
            if (request.getMethod() == null) {
                throw new IOException("We only support GET, PUT, PATCH, POST and DELETE.");
            }
            switch (request.getMethod()) {
                case GET: {
                    return this.get(request);
                }
                case POST: {
                    return this.post(request);
                }
                case PUT: {
                    return this.put(request);
                }
                case PATCH: {
                    return this.patch(request);
                }
                case DELETE: {
                    return this.delete(request);
                }
            }
            throw new IOException("We only support GET, PUT, PATCH, POST and DELETE.");
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (URISyntaxException ex) {
            StringWriter errors = new StringWriter();
            ex.printStackTrace(new PrintWriter(errors));
            throw new IOException(errors.toString());
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new Throwable(e.getMessage());
        }
        finally {
            super.finalize();
        }
    }
}

