/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.request;

import com.mashape.unirest.http.HttpMethod;
import com.mashape.unirest.http.utils.Base64Coder;
import com.mashape.unirest.http.utils.URLParamEncoder;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.body.Body;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpRequest
extends BaseRequest {
    private HttpMethod httpMethod;
    protected String url;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected Body body;

    private URL parseUrl(String s) throws Exception {
        return new URI(s.replaceAll("\\s+", "%20")).toURL();
    }

    public HttpRequest(HttpMethod method, String url) {
        this.httpMethod = method;
        this.url = url;
        this.httpRequest = this;
    }

    public HttpRequest routeParam(String name, String value) {
        Matcher matcher = Pattern.compile("\\{" + name + "\\}").matcher(this.url);
        int count = 0;
        while (matcher.find()) {
            ++count;
        }
        if (count == 0) {
            throw new RuntimeException("Can't find route parameter name \"" + name + "\"");
        }
        this.url = this.url.replaceAll("\\{" + name + "\\}", URLParamEncoder.encode(value));
        return this;
    }

    public HttpRequest basicAuth(String username, String password) {
        this.header("Authorization", "Basic " + Base64Coder.encodeString(username + ":" + password));
        return this;
    }

    public HttpRequest header(String name, String value) {
        List<String> list = this.headers.get(name.trim());
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(value);
        this.headers.put(name.trim(), list);
        return this;
    }

    public HttpRequest headers(Map<String, String> headers) {
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.header(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        try {
            return this.parseUrl(this.url).toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            return new HashMap<String, List<String>>();
        }
        return this.headers;
    }

    public Body getBody() {
        return this.body;
    }
}

