/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.http;

import com.mashape.unirest.http.HttpDeleteWithBody;
import com.mashape.unirest.http.HttpMethod;
import com.mashape.unirest.http.HttpPatchWithBody;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.async.Callback;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.http.options.Option;
import com.mashape.unirest.http.options.Options;
import com.mashape.unirest.http.utils.ClientFactory;
import com.mashape.unirest.request.HttpRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.nio.entity.NByteArrayEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClientHelper {
    private static final String USER_AGENT = "unirest-java/1.3.6";

    private static <T> FutureCallback<org.apache.http.HttpResponse> prepareCallback(final Class<T> responseClass, final Callback<T> callback) {
        if (callback == null) {
            return null;
        }
        return new FutureCallback<org.apache.http.HttpResponse>(){

            @Override
            public void cancelled() {
                callback.cancelled();
            }

            @Override
            public void completed(org.apache.http.HttpResponse arg0) {
                callback.completed(new HttpResponse(arg0, responseClass));
            }

            @Override
            public void failed(Exception arg0) {
                callback.failed(new UnirestException(arg0));
            }
        };
    }

    public static <T> Future<HttpResponse<T>> requestAsync(HttpRequest request, final Class<T> responseClass, Callback<T> callback) {
        HttpRequestBase requestObj = HttpClientHelper.prepareRequest(request, true);
        CloseableHttpAsyncClient asyncHttpClient = ClientFactory.getAsyncHttpClient();
        if (!asyncHttpClient.isRunning()) {
            asyncHttpClient.start();
        }
        final Future<org.apache.http.HttpResponse> future = asyncHttpClient.execute(requestObj, HttpClientHelper.prepareCallback(responseClass, callback));
        return new Future<HttpResponse<T>>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public HttpResponse<T> get() throws InterruptedException, ExecutionException {
                org.apache.http.HttpResponse httpResponse = (org.apache.http.HttpResponse)future.get();
                return new HttpResponse(httpResponse, responseClass);
            }

            @Override
            public HttpResponse<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                org.apache.http.HttpResponse httpResponse = (org.apache.http.HttpResponse)future.get(timeout, unit);
                return new HttpResponse(httpResponse, responseClass);
            }
        };
    }

    public static <T> HttpResponse<T> request(HttpRequest request, Class<T> responseClass) throws UnirestException {
        HttpRequestBase requestObj = HttpClientHelper.prepareRequest(request, false);
        HttpClient client = ClientFactory.getHttpClient();
        try {
            org.apache.http.HttpResponse response = client.execute(requestObj);
            HttpResponse<T> httpResponse = new HttpResponse<T>(response, responseClass);
            requestObj.releaseConnection();
            HttpResponse<T> httpResponse2 = httpResponse;
            return httpResponse2;
        }
        catch (Exception e) {
            throw new UnirestException(e);
        }
        finally {
            requestObj.releaseConnection();
        }
    }

    private static HttpRequestBase prepareRequest(HttpRequest request, boolean async) {
        request.header("user-agent", USER_AGENT);
        request.header("accept-encoding", "gzip");
        Object defaultHeaders = Options.getOption(Option.DEFAULT_HEADERS);
        if (defaultHeaders != null) {
            Set entrySet = ((Map)defaultHeaders).entrySet();
            for (Map.Entry entry : entrySet) {
                request.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        HttpRequestBase reqObj = null;
        switch (request.getHttpMethod()) {
            case GET: {
                reqObj = new HttpGet(request.getUrl());
                break;
            }
            case POST: {
                reqObj = new HttpPost(request.getUrl());
                break;
            }
            case PUT: {
                reqObj = new HttpPut(request.getUrl());
                break;
            }
            case DELETE: {
                reqObj = new HttpDeleteWithBody(request.getUrl());
                break;
            }
            case PATCH: {
                reqObj = new HttpPatchWithBody(request.getUrl());
            }
        }
        Set<Map.Entry<String, List<String>>> entrySet = request.getHeaders().entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            List<String> values = entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                reqObj.addHeader(entry.getKey(), value);
            }
        }
        if (request.getHttpMethod() != HttpMethod.GET && request.getBody() != null) {
            HttpEntity entity = request.getBody().getEntity();
            if (async) {
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    entity.writeTo(output);
                    NByteArrayEntity en = new NByteArrayEntity(output.toByteArray());
                    ((HttpEntityEnclosingRequestBase)reqObj).setEntity(en);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                ((HttpEntityEnclosingRequestBase)reqObj).setEntity(entity);
            }
        }
        return reqObj;
    }
}

