/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.java.kvdb;

import com.sinacloud.java.exception.NotInitializeException;
import com.sinacloud.java.kvdb.util.AuthExpire;
import com.sinacloud.java.kvdb.util.KeyPair;
import com.sinacloud.java.kvdb.util.TIOError;
import com.sinacloud.java.kvdb.util.TItem;
import com.sinacloud.java.kvdb.util.TKvdbService;
import com.sinacloud.java.kvdb.util.TransformUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.thrift.generated.IOError;
import org.apache.hadoop.hbase.thrift.generated.IllegalArgument;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaeKV {
    private static final Object EMPTY_VALUE = new Object();
    private static final int DEFAULT_RGET_QUERY_COUNT = 10;
    private static final int MAX_RGET_QUERY_COUNT = 512;
    private static final int DEFAULT_RDEL_DELETE_COUNT = 10;
    private static final int MAX_RDEL_DELETE_COUNT = 512;
    private static final int DEFAULT_PKRGET_QUERY_COUNT = 10;
    private static final int MAX_PKRGET_QUERY_COUNT = 100;
    private static final int MAX_VALUE_SIZE = 0x400000;
    private static final Logger logger = Logger.getLogger((String)SaeKV.class.getName());
    private static final String KVDB_SERVERS = System.getenv("KVDB_SERVERS");
    private static int KV_PORT;
    private static final List<String> KV_ADDRS;
    private static final AtomicInteger KV_ADDRS_INDEX;
    private static final int SUCCESS_CODE = 0;
    private static final int ERR_CODE = -1;
    private static final String SUCCESS_MSG = "success";
    private final String accessKey;
    private final String secretKey;
    private boolean initialized = false;
    private int errCode;
    private String errMsg;
    private final Token token;

    public SaeKV() {
        this.accessKey = System.getenv("ACCESSKEY");
        this.secretKey = System.getenv("SECRETKEY");
        this.token = new Token(this.accessKey, this.secretKey);
    }

    public SaeKV(String accesskey, String secretkey) {
        this.accessKey = accesskey;
        this.secretKey = secretkey;
        this.token = new Token(accesskey, secretkey);
    }

    public synchronized void init() {
        this.initialized = true;
        this.auth();
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new NotInitializeException("please invoke init() method.");
        }
    }

    private String addAccessKeyPrefix(String key) {
        return key;
    }

    private String removeAccessKeyPrefix(String key) {
        return key;
    }

    private void auth() {
        this.execute(new AuthExecutor());
    }

    private <T> T execute(AbstractThriftExecutor executor) {
        this.checkInitialized();
        String ip = this.token.getIp();
        if (ip == null) {
            this.connectWithAuth();
            ip = this.token.getIp();
        }
        TSocket transport = new TSocket(ip, KV_PORT);
        try {
            transport.open();
        }
        catch (TTransportException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
        TBinaryProtocol protocol = new TBinaryProtocol((TTransport)transport);
        TKvdbService.Client client = new TKvdbService.Client((TProtocol)protocol);
        Object t = executor.executorTemplate(client);
        transport.close();
        return t;
    }

    public KeyValue createConn() {
        TSocket transport = null;
        String ip = null;
        for (int i = 0; i < KV_ADDRS.size(); ++i) {
            ip = KV_ADDRS.get(Math.abs(KV_ADDRS_INDEX.incrementAndGet()) % KV_ADDRS.size());
            transport = new TSocket(ip, KV_PORT);
            for (int retry = 0; retry < 3; ++retry) {
                try {
                    transport.open();
                    break;
                }
                catch (TTransportException e) {
                    String unConnIp = KV_ADDRS.remove(i);
                    new Timer().schedule((TimerTask)new UnconnAddrTimer(unConnIp), 1800000L);
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
            }
            if (transport.isOpen()) break;
        }
        if (transport == null || ip == null) {
            throw new RuntimeException("cannot create connection");
        }
        KeyValue kv = new KeyValue(ip, transport);
        return kv;
    }

    private void connectWithAuth() {
        KeyValue kv = this.createConn();
        String ip = kv.key;
        TTransport transport = (TTransport)kv.value;
        TBinaryProtocol protocol = new TBinaryProtocol(transport);
        TKvdbService.Client client = new TKvdbService.Client((TProtocol)protocol);
        KeyPair kp = new KeyPair();
        long timestamp = System.currentTimeMillis();
        String content = this.accessKey + "-" + timestamp;
        String signature = TransformUtil.calcSignature(content, this.secretKey);
        kp.setAccesskey(this.accessKey);
        kp.setTimestamp(timestamp);
        kp.setSignature(signature);
        try {
            kp = client.auth(kp);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        this.token.setToken(kp.getToken());
        transport.close();
        this.token.setIp(ip);
    }

    public boolean delete(String key) {
        Object result = this.execute(new SingleExecutor(new KeyValue(key, EMPTY_VALUE)){

            public Boolean executor(KeyPair kp, TKvdbService.Client client, ByteBuffer row, Object value) throws IOError, TException, TIOError, AuthExpire {
                client.deleteItem(kp, row);
                return Boolean.TRUE;
            }
        });
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    @Deprecated
    public boolean delete(String key, Date expiry) {
        return this.delete(key);
    }

    public <T> T get(String key) {
        T result = this.execute(new SingleExecutor(new KeyValue(key, EMPTY_VALUE)){

            @Override
            public <T> T executor(KeyPair kp, TKvdbService.Client client, ByteBuffer row, Object value) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
                TItem item = client.getItem(kp, row);
                byte[] flagBytes = item.getFlag();
                byte[] content = item.getValue();
                return TransformUtil.getContent(flagBytes, content);
            }
        });
        if (result == null) {
            return null;
        }
        return result;
    }

    public boolean set(String key, boolean value) {
        return this.storeVlaue(key, value);
    }

    @Deprecated
    public boolean set(String key, boolean value, long expiry) {
        return this.set(key, value);
    }

    public boolean set(String key, byte[] value) {
        return this.storeVlaue(key, value);
    }

    @Deprecated
    public boolean set(String key, byte[] value, long expiry) {
        return this.set(key, value);
    }

    public boolean set(String key, double value) {
        return this.storeVlaue(key, value);
    }

    @Deprecated
    public boolean set(String key, double value, long expiry) {
        return this.set(key, value);
    }

    public boolean set(String key, long value) {
        return this.storeVlaue(key, value);
    }

    @Deprecated
    public boolean set(String key, long value, long expiry) {
        return this.set(key, value);
    }

    private void checkValueSize(byte[] value) {
        if (value != null && value.length > 0x400000) {
            throw new RuntimeException("value size must be less than 4M");
        }
    }

    private boolean storeVlaue(String key, Object value) {
        Object result = this.execute(new SingleExecutor(new KeyValue(key, value)){

            public Boolean executor(KeyPair kp, TKvdbService.Client client, ByteBuffer row, Object value) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
                byte[] flagContent = TransformUtil.getType(value);
                byte[] valueContent = TransformUtil.toBytes(value);
                SaeKV.this.checkValueSize(valueContent);
                TItem item = new TItem();
                item.setFlag(flagContent);
                item.setValue(valueContent);
                client.setItem(kp, row, item);
                return Boolean.TRUE;
            }
        });
        if (result == null) {
            return false;
        }
        return (Boolean)result;
    }

    public Map<String, Object> getMulti(String[] keys) {
        if (keys == null || keys.length == 0) {
            throw new RuntimeException("keys is empty");
        }
        ArrayList<KeyValue> list = new ArrayList<KeyValue>();
        for (String s : keys) {
            list.add(new KeyValue(s, EMPTY_VALUE));
        }
        Map map = (Map)this.execute(new BatchExecutor(list){

            @Override
            public <T> T executor(KeyPair kp, TKvdbService.Client client, Map<ByteBuffer, Object> values) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
                ArrayList<ByteBuffer> rows = new ArrayList<ByteBuffer>();
                for (ByteBuffer bb : values.keySet()) {
                    rows.add(bb);
                }
                Map<String, TItem> items = client.getItems(kp, rows);
                TreeMap result = new TreeMap();
                for (Map.Entry<String, TItem> entry : items.entrySet()) {
                    String key = SaeKV.this.removeAccessKeyPrefix(entry.getKey());
                    TItem item = entry.getValue();
                    byte[] flag = item.getFlag();
                    byte[] content = item.getValue();
                    Object obj = TransformUtil.getContent(flag, content);
                    result.put(key, obj);
                }
                return (T)result;
            }
        });
        return map;
    }

    public Map<String, Object> pkrget(String prefixKey, int queryCount, String compareKey) {
        return this.pkrget(prefixKey, queryCount, true, compareKey);
    }

    public Map<String, Object> pkrget(String prefixKey, String compareKey) {
        return this.pkrget(prefixKey, 10, true, compareKey);
    }

    public Map<String, Object> pkrget(String prefixKey, int queryCount, boolean isContainValue, String compareKey) {
        Map result = (Map)this.execute(new ScanExecutor(prefixKey, queryCount, isContainValue, compareKey, "", "", false, false, ScanType.PKRGET){

            @Override
            public <T> T executor(KeyPair kp, TKvdbService.Client client, ByteBuffer startAndPrefix, ByteBuffer stopKey, int count, boolean isContainValue, boolean isContainStartVlaue, boolean isContainEndValue, ByteBuffer compareKey) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
                Map<String, TItem> items = client.prkget(kp, startAndPrefix, count, isContainValue, compareKey);
                TreeMap result = new TreeMap();
                for (Map.Entry<String, TItem> entry : items.entrySet()) {
                    String key = SaeKV.this.removeAccessKeyPrefix(entry.getKey());
                    TItem item = entry.getValue();
                    byte[] flag = item.getFlag();
                    byte[] content = item.getValue();
                    Object obj = TransformUtil.getContent(flag, content);
                    result.put(key, obj);
                }
                return (T)result;
            }
        });
        return result;
    }

    public boolean rdel(String startKey, String endKey) {
        return this.rdel(startKey, endKey, true, true, 10);
    }

    public boolean rdel(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue) {
        return this.rdel(startKey, endKey, isContainStartVlaue, isContainEndValue, 10);
    }

    public boolean rdel(String startKey, String endKey, int deleteCount) {
        return this.rdel(startKey, endKey, true, true, deleteCount);
    }

    public boolean rdel(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, int deleteCount) {
        Object result = this.execute(new ScanExecutor("", deleteCount, false, "", startKey, endKey, isContainStartVlaue, isContainEndValue, ScanType.RDEL){

            public Boolean executor(KeyPair kp, TKvdbService.Client client, ByteBuffer startAndPrefix, ByteBuffer stopKey, int count, boolean isContainValue, boolean isContainStartVlaue, boolean isContainEndValue, ByteBuffer compareKey) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
                client.rdel(kp, startAndPrefix, stopKey, count);
                return Boolean.TRUE;
            }
        });
        return (Boolean)result;
    }

    public Map<String, Object> rget(String startKey, String endKey) {
        return this.rget(startKey, endKey, true, true, 10);
    }

    public Map<String, Object> rget(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue) {
        return this.rget(startKey, endKey, isContainStartVlaue, isContainEndValue, 10);
    }

    public Map<String, Object> rget(String startKey, String endKey, int queryCount) {
        return this.rget(startKey, endKey, true, true, queryCount);
    }

    public Map<String, Object> rget(String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, int queryCount) {
        Map result = (Map)this.execute(new ScanExecutor("", queryCount, false, "", startKey, endKey, isContainStartVlaue, isContainEndValue, ScanType.RDEL){

            @Override
            public <T> T executor(KeyPair kp, TKvdbService.Client client, ByteBuffer startAndPrefix, ByteBuffer stopKey, int count, boolean isContainValue, boolean isContainStartVlaue, boolean isContainEndValue, ByteBuffer compareKey) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
                Map<String, TItem> items = client.rget(kp, startAndPrefix, stopKey, count);
                TreeMap result = new TreeMap();
                for (Map.Entry<String, TItem> entry : items.entrySet()) {
                    String key = SaeKV.this.removeAccessKeyPrefix(entry.getKey());
                    TItem item = entry.getValue();
                    byte[] flag = item.getFlag();
                    byte[] content = item.getValue();
                    Object obj = TransformUtil.getContent(flag, content);
                    result.put(key, obj);
                }
                return (T)result;
            }
        });
        return result;
    }

    public void setOptions(String option) {
    }

    @Deprecated
    public Map<String, Long> getInfo() {
        this.checkInitialized();
        return new HashMap<String, Long>();
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    private void recordErrCodeAndMsg(int code, String msg) {
        this.errCode = code;
        this.errMsg = msg;
    }

    static {
        KV_ADDRS_INDEX = new AtomicInteger(0);
        try {
            String[] addrs = KVDB_SERVERS.split(",");
            ArrayList<String> list = new ArrayList<String>();
            for (String s : addrs) {
                list.add(s.split(":")[0]);
                KV_PORT = Integer.parseInt(s.split(":")[1]);
            }
            Collections.shuffle(list);
            KV_ADDRS = new CopyOnWriteArrayList<String>();
            KV_ADDRS.addAll(list);
            Random rand = new Random();
            KV_ADDRS_INDEX.addAndGet(rand.nextInt(addrs.length));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private class UnconnAddrTimer
    extends TimerTask {
        private final String ip;

        public UnconnAddrTimer(String ip) {
            this.ip = ip;
        }

        public void run() {
            KV_ADDRS.add(this.ip);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class ScanExecutor
    extends AbstractThriftExecutor {
        final String prefixKey;
        final int count;
        final boolean isContainValue;
        final String compareKey;
        final String startKey;
        final String endKey;
        final boolean isContainStartVlaue;
        final boolean isContainEndValue;
        final ScanType type;

        public ScanExecutor(String prefixKey, int count, boolean isContainValue, String compareKey, String startKey, String endKey, boolean isContainStartVlaue, boolean isContainEndValue, ScanType type) {
            this.type = type;
            switch (type) {
                case PKRGET: {
                    if (prefixKey == null || "".equals(prefixKey)) {
                        throw new IllegalArgumentException("prefixkey is null");
                    }
                    this.prefixKey = prefixKey;
                    this.count = count > 100 ? 100 : count;
                    if (compareKey == null || "".equals(compareKey)) {
                        throw new IllegalArgumentException("compare key is null");
                    }
                    this.compareKey = compareKey;
                    this.isContainValue = isContainValue;
                    this.startKey = startKey;
                    this.endKey = endKey;
                    this.isContainStartVlaue = isContainStartVlaue;
                    this.isContainEndValue = isContainEndValue;
                    break;
                }
                case RGET: {
                    if (startKey == null || "".equals(startKey)) {
                        throw new IllegalArgumentException("start key is null");
                    }
                    this.startKey = startKey;
                    if (endKey == null || "".equals(endKey)) {
                        throw new IllegalArgumentException("end key is null");
                    }
                    this.endKey = endKey;
                    this.isContainStartVlaue = isContainStartVlaue;
                    this.isContainEndValue = isContainEndValue;
                    this.count = count > 512 ? 512 : count;
                    this.prefixKey = prefixKey;
                    this.compareKey = compareKey;
                    this.isContainValue = isContainValue;
                    break;
                }
                case RDEL: {
                    if (startKey == null || "".equals(startKey)) {
                        throw new IllegalArgumentException("start key is null");
                    }
                    this.startKey = startKey;
                    if (endKey == null || "".equals(endKey)) {
                        throw new IllegalArgumentException("end key is null");
                    }
                    this.endKey = endKey;
                    this.isContainStartVlaue = isContainStartVlaue;
                    this.isContainEndValue = isContainEndValue;
                    this.count = count > 512 ? 512 : count;
                    this.prefixKey = prefixKey;
                    this.compareKey = compareKey;
                    this.isContainValue = isContainValue;
                    break;
                }
                default: {
                    throw new RuntimeException("unkonw scan type");
                }
            }
        }

        @Override
        public <T> T executorTemplate(TKvdbService.Client client) {
            T result = null;
            ByteBuffer startAndPrefix = null;
            ByteBuffer stopKey = null;
            ByteBuffer compKey = null;
            try {
                switch (this.type) {
                    case PKRGET: {
                        String encodeKey = TransformUtil.encodeKey(this.prefixKey);
                        startAndPrefix = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(encodeKey));
                        String compKeyStr = TransformUtil.encodeKey(this.compareKey);
                        compKey = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(compKeyStr));
                        break;
                    }
                    case RGET: {
                        String encodeKey = TransformUtil.encodeKey(this.startKey);
                        startAndPrefix = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(encodeKey));
                        encodeKey = TransformUtil.encodeKey(this.endKey);
                        stopKey = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(encodeKey));
                        break;
                    }
                    case RDEL: {
                        String encodeKey = TransformUtil.encodeKey(this.startKey);
                        startAndPrefix = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(encodeKey));
                        encodeKey = TransformUtil.encodeKey(this.endKey);
                        stopKey = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(encodeKey));
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"encode key failure.", (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
                return null;
            }
            try {
                try {
                    KeyPair kp = new KeyPair();
                    kp.setToken(SaeKV.this.token.getToken());
                    result = this.executor(kp, client, startAndPrefix, stopKey, this.count, this.isContainValue, this.isContainStartVlaue, this.isContainEndValue, compKey);
                }
                catch (AuthExpire e) {
                    SaeKV.this.auth();
                    KeyPair kp = new KeyPair();
                    kp.setToken(SaeKV.this.token.getToken());
                    result = this.executor(kp, client, startAndPrefix, stopKey, this.count, this.isContainValue, this.isContainStartVlaue, this.isContainEndValue, compKey);
                }
                SaeKV.this.recordErrCodeAndMsg(0, SaeKV.SUCCESS_MSG);
            }
            catch (IOError e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (TException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (IllegalArgument e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BatchExecutor
    extends AbstractThriftExecutor {
        final List<KeyValue> kvs;

        public BatchExecutor(List<KeyValue> kvs) {
            if (kvs == null) {
                throw new RuntimeException("keys and values is null");
            }
            this.kvs = kvs;
        }

        @Override
        public <T> T executorTemplate(TKvdbService.Client client) {
            HashMap<ByteBuffer, Object> map = new HashMap<ByteBuffer, Object>();
            T result = null;
            ByteBuffer row = null;
            try {
                for (KeyValue k : this.kvs) {
                    String encodeKey = TransformUtil.encodeKey(k.key);
                    row = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(encodeKey));
                    map.put(row, k.value);
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"encode key failure.", (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
                return null;
            }
            try {
                try {
                    KeyPair kp = new KeyPair();
                    kp.setToken(SaeKV.this.token.getToken());
                    result = this.executor(kp, client, map);
                }
                catch (AuthExpire e) {
                    SaeKV.this.auth();
                    KeyPair kp = new KeyPair();
                    kp.setToken(SaeKV.this.token.getToken());
                    result = this.executor(kp, client, map);
                }
                SaeKV.this.recordErrCodeAndMsg(0, SaeKV.SUCCESS_MSG);
            }
            catch (IOError e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (TException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (IllegalArgument e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SingleExecutor
    extends AbstractThriftExecutor {
        final KeyValue kv;

        public SingleExecutor(KeyValue kv) {
            this.kv = kv;
        }

        @Override
        public <T> T executorTemplate(TKvdbService.Client client) {
            T result = null;
            ByteBuffer row = null;
            try {
                String encodeKey = TransformUtil.encodeKey(this.kv.key);
                row = TransformUtil.wrap(SaeKV.this.addAccessKeyPrefix(encodeKey));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"encode key failure.", (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
                return null;
            }
            try {
                try {
                    KeyPair kp = new KeyPair();
                    kp.setToken(SaeKV.this.token.getToken());
                    result = this.executor(kp, client, row, this.kv.value);
                }
                catch (AuthExpire e) {
                    SaeKV.this.auth();
                    KeyPair kp = new KeyPair();
                    kp.setToken(SaeKV.this.token.getToken());
                    result = this.executor(kp, client, row, this.kv.value);
                }
                SaeKV.this.recordErrCodeAndMsg(0, SaeKV.SUCCESS_MSG);
            }
            catch (IOError e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (TException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (IllegalArgument e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                SaeKV.this.recordErrCodeAndMsg(-1, e.getMessage());
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthExecutor
    extends AbstractThriftExecutor {
        private AuthExecutor() {
        }

        @Override
        public <T> T executorTemplate(TKvdbService.Client client) {
            KeyPair kp = new KeyPair();
            long timestamp = System.currentTimeMillis();
            String content = SaeKV.this.accessKey + "-" + timestamp;
            String signature = TransformUtil.calcSignature(content, SaeKV.this.secretKey);
            kp.setAccesskey(SaeKV.this.accessKey);
            kp.setTimestamp(timestamp);
            kp.setSignature(signature);
            try {
                kp = client.auth(kp);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            SaeKV.this.token.setToken(kp.getToken());
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractThriftExecutor
    implements ThriftExecutor {
        private AbstractThriftExecutor() {
        }

        public abstract <T> T executorTemplate(TKvdbService.Client var1);

        @Override
        public <T> T executor(KeyPair kp, TKvdbService.Client client, ByteBuffer row, Object value) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
            throw new RuntimeException("Unsupported");
        }

        @Override
        public <T> T executor(KeyPair kp, TKvdbService.Client client, Map<ByteBuffer, Object> values) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
            throw new RuntimeException("Unsupported");
        }

        @Override
        public <T> T executor(KeyPair kp, TKvdbService.Client client, ByteBuffer startAndPrefix, ByteBuffer stopKey, int count, boolean isContainValue, boolean isContainStartVlaue, boolean isContainEndValue, ByteBuffer compareKey) throws IOError, TException, IllegalArgument, TIOError, AuthExpire {
            throw new RuntimeException("Unsupported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ThriftExecutor {
        public <T> T executor(KeyPair var1, TKvdbService.Client var2, ByteBuffer var3, Object var4) throws IOError, TException, IllegalArgument, TIOError, AuthExpire;

        public <T> T executor(KeyPair var1, TKvdbService.Client var2, Map<ByteBuffer, Object> var3) throws IOError, TException, IllegalArgument, TIOError, AuthExpire;

        public <T> T executor(KeyPair var1, TKvdbService.Client var2, ByteBuffer var3, ByteBuffer var4, int var5, boolean var6, boolean var7, boolean var8, ByteBuffer var9) throws IOError, TException, IllegalArgument, TIOError, AuthExpire;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ScanType {
        PKRGET,
        RGET,
        RDEL;

    }

    private class Token {
        private final String accesskey;
        private final String secretkey;
        private String token;
        private String ip;

        public Token(String accesskey, String secretkey) {
            this.accesskey = accesskey;
            this.secretkey = secretkey;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }
    }

    private class KeyValue {
        final String key;
        final Object value;

        public KeyValue(String key, Object value) {
            if (key == null) {
                throw new RuntimeException("key is null");
            }
            if (value == null) {
                throw new RuntimeException("value is null");
            }
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "key=" + this.key + "\tvalue=" + this.value.toString();
        }
    }
}

