/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.java.kvdb.util;

import com.sinacloud.java.exception.BanCallException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformUtil {
    private static final byte[] LONG_FLAG = "1".getBytes();
    private static final byte[] DOUBLE_FLAG = "2".getBytes();
    private static final byte[] BOOLEAN_FLAG = "3".getBytes();
    private static final byte[] SERIALIZED_FLAG = "0".getBytes();
    private static final String DEFAULT_ENCODE = "UTF-8";
    private static final int MAX_KEY_LENGTH = 101;

    private TransformUtil() {
        throw new BanCallException("can not invoke TransformUtil constructor.");
    }

    public static String encodeKey(String key) throws UnsupportedEncodingException {
        return URLEncoder.encode(key, DEFAULT_ENCODE);
    }

    public static String encodeKey(byte[] key) throws UnsupportedEncodingException {
        return TransformUtil.encodeKey(new String(key, DEFAULT_ENCODE));
    }

    public static String decodeKey(String key) throws UnsupportedEncodingException {
        return URLDecoder.decode(key, DEFAULT_ENCODE);
    }

    public static <T> T getContent(byte[] type, byte[] content) {
        if (type == null) {
            throw new RuntimeException("kvdb type error,type is null");
        }
        if (content == null) {
            throw new RuntimeException("kvdb type error,value is null");
        }
        byte b = type[0];
        Object result = null;
        if (b == LONG_FLAG[0]) {
            String str = new String(content);
            Long v = Long.parseLong(str);
            result = v;
        } else if (b == DOUBLE_FLAG[0]) {
            String str = new String(content);
            Double v = Double.parseDouble(str);
            result = v;
        } else if (b == BOOLEAN_FLAG[0]) {
            String str = new String(content);
            Boolean v = Boolean.parseBoolean(str);
            result = v;
        } else if (b == SERIALIZED_FLAG[0]) {
            result = content;
        } else {
            throw new RuntimeException("unsupported type");
        }
        return (T)result;
    }

    public static byte[] getType(Object value) {
        if (value instanceof Long) {
            return LONG_FLAG;
        }
        if (value instanceof Double) {
            return DOUBLE_FLAG;
        }
        if (value instanceof Boolean) {
            return BOOLEAN_FLAG;
        }
        if (value instanceof byte[]) {
            return SERIALIZED_FLAG;
        }
        throw new RuntimeException("unsupported type");
    }

    public static byte[] toBytes(Object value) {
        if (value instanceof Long) {
            Long longObject = (Long)value;
            return longObject.toString().getBytes();
        }
        if (value instanceof Double) {
            Double doubleObject = (Double)value;
            return doubleObject.toString().getBytes();
        }
        if (value instanceof Boolean) {
            Boolean booleanObject = (Boolean)value;
            return booleanObject.toString().getBytes();
        }
        if (value instanceof byte[]) {
            byte[] buf = (byte[])value;
            return buf;
        }
        throw new RuntimeException("unsupported value type");
    }

    public static ByteBuffer wrap(String value) throws UnsupportedEncodingException {
        ByteBuffer bb = null;
        bb = ByteBuffer.wrap(value.getBytes(DEFAULT_ENCODE));
        return bb;
    }

    public static Map<ByteBuffer, ByteBuffer> encodeAttributes(Map<String, String> attributes) throws UnsupportedEncodingException {
        HashMap<ByteBuffer, ByteBuffer> wrappedAttributes = null;
        if (attributes != null && !attributes.isEmpty()) {
            wrappedAttributes = new HashMap<ByteBuffer, ByteBuffer>(1);
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                wrappedAttributes.put(TransformUtil.wrap(entry.getKey()), TransformUtil.wrap(entry.getValue()));
            }
        }
        return wrappedAttributes;
    }

    public static Map<ByteBuffer, ByteBuffer> emptyAttributes() throws UnsupportedEncodingException {
        return TransformUtil.encodeAttributes(new HashMap<String, String>());
    }

    public static byte[] decodeBuffer(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.limit()];
        for (int i = 0; i < buffer.limit(); ++i) {
            bytes[i] = buffer.get();
        }
        return bytes;
    }

    private static int getValueSize(Object value) {
        if (value == null) {
            throw new RuntimeException("vlaue is null");
        }
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof Double) {
            return 8;
        }
        if (value instanceof Long) {
            return 8;
        }
        if (value instanceof byte[]) {
            byte[] buf = (byte[])value;
            return buf.length;
        }
        throw new RuntimeException("unkonwn value type " + value.getClass().getName());
    }

    private static int getKeySize(String key) {
        if (key == null) {
            throw new RuntimeException("key is null");
        }
        return key.getBytes().length;
    }

    public static byte[] generateStopKey(ByteBuffer startKey) {
        int index;
        byte[] keyBytes = new byte[101];
        byte[] startKeyBuf = TransformUtil.decodeBuffer(startKey);
        for (index = 0; index < startKeyBuf.length; ++index) {
            keyBytes[index] = startKeyBuf[index];
        }
        while (index < keyBytes.length) {
            keyBytes[index] = -1;
            ++index;
        }
        return keyBytes;
    }

    public static byte[] caclStopKey(String startKey) {
        try {
            return TransformUtil.caclStopKey(TransformUtil.wrap(startKey));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static byte[] caclStopKey(ByteBuffer startKey) {
        if (startKey == null) {
            throw new RuntimeException("start key is null");
        }
        byte[] keyBytes = TransformUtil.decodeBuffer(startKey);
        BigInteger bi = new BigInteger(keyBytes);
        BigInteger value = bi.add(new BigInteger("1"));
        byte[] stopKey = value.toByteArray();
        return stopKey;
    }

    public static String calcSignature(String content, String secretKey) {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret = new SecretKeySpec(secretKey.getBytes(), "HmacSHA256");
            mac.init(secret);
            byte[] digest = mac.doFinal(content.getBytes());
            BASE64Encoder encode = new BASE64Encoder();
            return encode.encode(digest);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

