/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.auth;

import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.auth.AWSCredentials;
import com.sinacloud.scs.auth.AWSCredentialsProvider;
import com.sinacloud.scs.auth.PropertiesCredentials;
import java.io.IOException;
import java.io.InputStream;

public class ClasspathPropertiesFileCredentialsProvider
implements AWSCredentialsProvider {
    private static String DEFAULT_PROPERTIES_FILE = "SCSCredentials.properties";
    private final String credentialsFilePath;

    public ClasspathPropertiesFileCredentialsProvider() {
        this(DEFAULT_PROPERTIES_FILE);
    }

    public ClasspathPropertiesFileCredentialsProvider(String credentialsFilePath) {
        if (credentialsFilePath == null) {
            throw new IllegalArgumentException("Credentials file path cannot be null");
        }
        this.credentialsFilePath = !credentialsFilePath.startsWith("/") ? "/" + credentialsFilePath : credentialsFilePath;
    }

    public AWSCredentials getCredentials() {
        InputStream inputStream = this.getClass().getResourceAsStream(this.credentialsFilePath);
        if (inputStream == null) {
            throw new SCSClientException("Unable to load AWS credentials from the " + this.credentialsFilePath + " file on the classpath");
        }
        try {
            return new PropertiesCredentials(inputStream);
        }
        catch (IOException e) {
            throw new SCSClientException("Unable to load AWS credentials from the " + this.credentialsFilePath + " file on the classpath", e);
        }
    }

    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.credentialsFilePath + ")";
    }
}

