/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.internal;

import com.sinacloud.scs.SCSWebServiceResponse;
import com.sinacloud.scs.http.HttpResponse;
import com.sinacloud.scs.services.scs.internal.HeaderHandler;
import com.sinacloud.scs.services.scs.internal.S3JsonResponseHandler;
import com.sinacloud.scs.transform.Unmarshaller;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseHeaderHandlerChain<T>
extends S3JsonResponseHandler<T> {
    private final List<HeaderHandler<T>> headerHandlers;

    public ResponseHeaderHandlerChain(Unmarshaller<T, InputStream> responseUnmarshaller, HeaderHandler<T> ... headerHandlers) {
        super(responseUnmarshaller);
        this.headerHandlers = Arrays.asList(headerHandlers);
    }

    @Override
    public SCSWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        Object awsResponse = super.handle(response);
        Object result = ((SCSWebServiceResponse)awsResponse).getResult();
        if (result != null) {
            for (HeaderHandler handler : this.headerHandlers) {
                handler.handle(result, response);
            }
        }
        return awsResponse;
    }
}

