/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.internal;

import com.sinacloud.scs.SCSServiceException;
import com.sinacloud.scs.http.HttpMethodName;
import com.sinacloud.scs.http.HttpResponse;
import com.sinacloud.scs.http.HttpResponseHandler;
import com.sinacloud.scs.services.scs.model.SCSS3Exception;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ErrorResponseHandler
implements HttpResponseHandler<SCSServiceException> {
    private static final Log log = LogFactory.getLog(S3ErrorResponseHandler.class);

    @Override
    public SCSServiceException handle(HttpResponse errorResponse) throws Exception {
        if (errorResponse.getContent() == null || errorResponse.getRequest().getHttpMethod() == HttpMethodName.HEAD) {
            String requestId = errorResponse.getHeaders().get("x-requestid");
            String extendedRequestId = errorResponse.getHeaders().get("x-amz-id-2");
            SCSS3Exception ase = new SCSS3Exception(errorResponse.getStatusText());
            ase.setStatusCode(errorResponse.getStatusCode());
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(extendedRequestId);
            this.fillInErrorType(ase, errorResponse);
            return ase;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)errorResponse.getHttpRequest().getURI());
            for (Header h : errorResponse.getHttpRequest().getAllHeaders()) {
                log.debug((Object)h);
            }
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(errorResponse.getContent()));
        StringBuffer buffer = new StringBuffer();
        String line = "";
        while ((line = in.readLine()) != null) {
            buffer.append(line);
        }
        SCSS3Exception ase = new SCSS3Exception(buffer.toString());
        ase.setStatusCode(errorResponse.getStatusCode());
        ase.setErrorCode(errorResponse.getHeaders().get("x-error-code"));
        ase.setRequestId(errorResponse.getHeaders().get("x-requestid"));
        this.fillInErrorType(ase, errorResponse);
        return ase;
    }

    private void fillInErrorType(SCSServiceException ase, HttpResponse errorResponse) {
        if (errorResponse.getStatusCode() >= 500) {
            ase.setErrorType(SCSServiceException.ErrorType.Service);
        } else {
            ase.setErrorType(SCSServiceException.ErrorType.Client);
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

