/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.internal;

import com.sinacloud.scs.Request;
import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.auth.AWSCredentials;
import com.sinacloud.scs.auth.AWSSessionCredentials;
import com.sinacloud.scs.auth.AbstractAWSSigner;
import com.sinacloud.scs.auth.SigningAlgorithm;
import com.sinacloud.scs.services.scs.internal.RestUtils;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3QueryStringSigner<T>
extends AbstractAWSSigner {
    private final String httpVerb;
    private final String resourcePath;
    private final Date expiration;

    public S3QueryStringSigner(String httpVerb, String resourcePath, Date expiration) {
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        this.expiration = expiration;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) throws SCSClientException {
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
        }
        String expirationInSeconds = Long.toString(this.expiration.getTime() / 1000L);
        String canonicalString = RestUtils.makeS3CanonicalString(this.httpVerb, this.resourcePath, request, expirationInSeconds);
        String signature = super.signAndBase64Encode(canonicalString, sanitizedCredentials.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        signature = signature.substring(5, 15);
        request.addParameter("KID", "sina," + sanitizedCredentials.getAWSAccessKeyId());
        request.addParameter("Expires", expirationInSeconds);
        request.addParameter("ssig", signature);
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials credentials) {
        request.addParameter("x-amz-security-token", credentials.getSessionToken());
    }
}

