/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.model;

import com.sinacloud.scs.services.scs.model.Owner;
import com.sinacloud.scs.util.DateUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bucket {
    private String name = null;
    private Owner owner = null;
    private Date creationDate = null;
    private long consumedBytes = 0L;

    public Bucket() {
    }

    public Bucket(String name) {
        this.name = name;
    }

    public Bucket(Map<String, Object> bucketJsonMap, Owner owner) {
        this.name = (String)bucketJsonMap.get("Name");
        this.owner = owner;
        String creationDateStr = (String)bucketJsonMap.get("CreationDate");
        if (creationDateStr != null && !"".equals(creationDateStr)) {
            DateUtils du = new DateUtils();
            try {
                this.setCreationDate(du.parseRfc822Date(creationDateStr));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        this.setConsumedBytes(((Double)bucketJsonMap.get("ConsumedBytes")).longValue());
    }

    public String toString() {
        return "S3Bucket [name=" + this.getName() + ", creationDate=" + this.getCreationDate() + ", owner=" + this.getOwner() + ", consumedBytes=" + this.getConsumedBytes() + "]";
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getConsumedBytes() {
        return this.consumedBytes;
    }

    public void setConsumedBytes(long consumedBytes) {
        this.consumedBytes = consumedBytes;
    }
}

