/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.model;

import com.sinacloud.scs.services.scs.model.S3ObjectSummary;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectListing {
    private int contentsQuantity;
    private int commonPrefixesQuantity;
    private List<S3ObjectSummary> objectSummaries = new ArrayList<S3ObjectSummary>();
    private List<Map<String, String>> commonPrefixes = new ArrayList<Map<String, String>>();
    private String bucketName;
    private String nextMarker;
    private boolean isTruncated;
    private String prefix;
    private String marker;
    private int maxKeys;
    private String delimiter;

    public ObjectListing(Map<String, Object> jsonMap) {
        if (jsonMap != null) {
            this.delimiter = (String)jsonMap.get("Delimiter");
            this.prefix = (String)jsonMap.get("Prefix");
            this.commonPrefixes = (List)jsonMap.get("CommonPrefixes");
            this.marker = (String)jsonMap.get("Marker");
            this.contentsQuantity = ((Double)jsonMap.get("ContentsQuantity")).intValue();
            this.commonPrefixesQuantity = ((Double)jsonMap.get("CommonPrefixesQuantity")).intValue();
            this.nextMarker = (String)jsonMap.get("NextMarker");
            this.isTruncated = (Boolean)jsonMap.get("IsTruncated");
            List contents = (List)jsonMap.get("Contents");
            if (contents != null) {
                for (Map content : contents) {
                    S3ObjectSummary s3Obj = new S3ObjectSummary(content);
                    this.objectSummaries.add(s3Obj);
                }
            }
        }
    }

    public ObjectListing() {
    }

    public List<S3ObjectSummary> getObjectSummaries() {
        return this.objectSummaries;
    }

    public List<Map<String, String>> getCommonPrefixes() {
        return this.commonPrefixes;
    }

    public void setCommonPrefixes(List<Map<String, String>> commonPrefixes) {
        this.commonPrefixes = commonPrefixes;
    }

    public String getNextMarker() {
        return this.nextMarker;
    }

    public void setNextMarker(String nextMarker) {
        this.nextMarker = nextMarker;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    public void setMaxKeys(int maxKeys) {
        this.maxKeys = maxKeys;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setTruncated(boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public int getContentsQuantity() {
        return this.contentsQuantity;
    }

    public void setContentsQuantity(int contentsQuantity) {
        this.contentsQuantity = contentsQuantity;
    }

    public int getCommonPrefixesQuantity() {
        return this.commonPrefixesQuantity;
    }

    public void setCommonPrefixesQuantity(int commonPrefixesQuantity) {
        this.commonPrefixesQuantity = commonPrefixesQuantity;
    }

    public String toString() {
        return "ObjectListing [delimiter=" + this.getDelimiter() + ", drefix=" + this.getPrefix() + ", commonPrefixesQuantity=" + this.getCommonPrefixesQuantity() + ", commonPrefixes=" + this.getCommonPrefixes() + ", marker=" + this.getMarker() + ", nextMarker=" + this.getNextMarker() + ", isTruncated=" + this.isTruncated() + ", contentsQuantity=" + this.getContentsQuantity() + ", objectSummaries=" + this.getObjectSummaries() + "]";
    }
}

