/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.model;

import com.sinacloud.scs.services.scs.model.Owner;
import com.sinacloud.scs.util.DateUtils;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ObjectSummary {
    protected String sha1;
    protected Date expiration;
    protected String contentType;
    protected String bucketName;
    protected String key;
    protected String eTag;
    protected long size;
    protected Date lastModified;
    protected Owner owner;

    public S3ObjectSummary(Map<String, Object> jsonMap) {
        if (jsonMap != null) {
            this.sha1 = (String)jsonMap.get("SHA1");
            this.key = (String)jsonMap.get("Name");
            DateUtils du = new DateUtils();
            if (jsonMap.get("Expiration-Time") != null) {
                try {
                    this.expiration = du.parseRfc822Date((String)jsonMap.get("Expiration-Time"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (jsonMap.get("Last-Modified") != null) {
                try {
                    this.lastModified = du.parseRfc822Date((String)jsonMap.get("Last-Modified"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.owner = new Owner((String)jsonMap.get("Owner"), "");
            this.eTag = (String)jsonMap.get("MD5");
            this.contentType = (String)jsonMap.get("Content-Type");
            this.size = ((Double)jsonMap.get("Size")).intValue();
        }
    }

    public String toString() {
        return "S3ObjectSummary [sha1=" + this.getSha1() + ", key=" + this.getKey() + ", expiration=" + this.getExpiration() + ", lastModified=" + this.getLastModified() + ", owner=" + this.getOwner() + ", eTag=" + this.getETag() + ", contentType=" + this.getContentType() + ", size=" + this.getSize() + "]";
    }

    public String getSha1() {
        return this.sha1;
    }

    public void setSha1(String sha1) {
        this.sha1 = sha1;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public Owner getOwner() {
        return this.owner;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }
}

