/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.model.transform;

import com.google.gson.Gson;
import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.services.scs.internal.Constants;
import com.sinacloud.scs.services.scs.model.AccessControlList;
import com.sinacloud.scs.services.scs.model.Bucket;
import com.sinacloud.scs.services.scs.model.BucketInfo;
import com.sinacloud.scs.services.scs.model.InitiateMultipartUploadResult;
import com.sinacloud.scs.services.scs.model.ObjectInfo;
import com.sinacloud.scs.services.scs.model.ObjectListing;
import com.sinacloud.scs.services.scs.model.Owner;
import com.sinacloud.scs.services.scs.model.PartListing;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonResponsesParser {
    private static final Log log = LogFactory.getLog(JsonResponsesParser.class);

    public ObjectListing parseListBucketObjectsResponse(InputStream inputStream) throws SCSClientException {
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            Gson gson = new Gson();
            Map modelObject = (Map)gson.fromJson((Reader)breader, Map.class);
            return new ObjectListing(modelObject);
        }
        catch (Throwable t) {
            block4: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block4;
                    log.error((Object)"Unable to close response InputStream up after json parse failure", (Throwable)e);
                }
            }
            t.printStackTrace();
            throw new SCSClientException("Failed to parse json document with handler --" + t.getLocalizedMessage(), t);
        }
    }

    public List<Bucket> parseListMyBucketsResponse(InputStream inputStream) throws SCSClientException {
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            ArrayList<Bucket> resultList = new ArrayList<Bucket>();
            Gson gson = new Gson();
            Map modelObject = (Map)gson.fromJson((Reader)breader, Map.class);
            if (modelObject != null && modelObject.get("Buckets") != null) {
                Map ownerMap = (Map)modelObject.get("Owner");
                Owner owner = new Owner((String)ownerMap.get("ID"), (String)ownerMap.get("DisplayName"));
                List bucketList = (List)modelObject.get("Buckets");
                for (Map bucketMap : bucketList) {
                    resultList.add(new Bucket(bucketMap, owner));
                }
            }
            return resultList;
        }
        catch (Throwable t) {
            block6: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block6;
                    log.error((Object)"Unable to close response InputStream up after json parse failure", (Throwable)e);
                }
            }
            t.printStackTrace();
            throw new SCSClientException("Failed to parse json document with handler ", t);
        }
    }

    public AccessControlList parseAccessControlListResponse(InputStream inputStream) throws SCSClientException {
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            Gson gson = new Gson();
            Map jsonObject = (Map)gson.fromJson((Reader)breader, Map.class);
            if (jsonObject != null) {
                return new AccessControlList(jsonObject);
            }
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after json parse failure", (Throwable)e);
                }
            }
            throw new SCSClientException("Failed to parse json document with handler ", t);
        }
        return null;
    }

    public ObjectInfo parseObjectInfoResponse(InputStream inputStream) throws SCSClientException {
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            Gson gson = new Gson();
            Map jsonObject = (Map)gson.fromJson((Reader)breader, Map.class);
            if (jsonObject != null) {
                return new ObjectInfo(jsonObject);
            }
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after json parse failure", (Throwable)e);
                }
            }
            t.printStackTrace();
            throw new SCSClientException("Failed to parse json document with handler ", t);
        }
        return null;
    }

    public BucketInfo parseBucketInfoResponse(InputStream inputStream) throws SCSClientException {
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            Gson gson = new Gson();
            Map jsonObject = (Map)gson.fromJson((Reader)breader, Map.class);
            if (jsonObject != null) {
                return new BucketInfo(jsonObject);
            }
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after json parse failure", (Throwable)e);
                }
            }
            throw new SCSClientException("Failed to parse json document with handler ", t);
        }
        return null;
    }

    public InitiateMultipartUploadResult parseInitiateMultipartUploadResponse(InputStream inputStream) throws SCSClientException {
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            Gson gson = new Gson();
            Map jsonObject = (Map)gson.fromJson((Reader)breader, Map.class);
            if (jsonObject != null) {
                return new InitiateMultipartUploadResult(jsonObject);
            }
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after json parse failure", (Throwable)e);
                }
            }
            throw new SCSClientException("Failed to parse json document with handler ", t);
        }
        return null;
    }

    public PartListing parseListPartsResponse(InputStream inputStream) throws SCSClientException {
        try {
            BufferedReader breader = new BufferedReader(new InputStreamReader(inputStream, Constants.DEFAULT_ENCODING));
            Gson gson = new Gson();
            Map jsonObject = (Map)gson.fromJson((Reader)breader, Map.class);
            if (jsonObject != null) {
                return new PartListing(jsonObject);
            }
        }
        catch (Throwable t) {
            block5: {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block5;
                    log.error((Object)"Unable to close response InputStream up after json parse failure", (Throwable)e);
                }
            }
            throw new SCSClientException("Failed to parse json document with handler ", t);
        }
        return null;
    }
}

