/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.transfer.internal;

import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.SCSServiceException;
import com.sinacloud.scs.event.ProgressEvent;
import com.sinacloud.scs.event.ProgressListenerCallbackExecutor;
import com.sinacloud.scs.services.scs.model.LegacyS3ProgressListener;
import com.sinacloud.scs.services.scs.model.ProgressListener;
import com.sinacloud.scs.services.scs.transfer.Transfer;
import com.sinacloud.scs.services.scs.transfer.TransferProgress;
import com.sinacloud.scs.services.scs.transfer.internal.ProgressListenerChain;
import com.sinacloud.scs.services.scs.transfer.internal.TransferMonitor;
import com.sinacloud.scs.services.scs.transfer.internal.TransferStateChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class AbstractTransfer
implements Transfer {
    protected volatile Transfer.TransferState state = Transfer.TransferState.Waiting;
    protected TransferMonitor monitor;
    private final TransferProgress transferProgress;
    private final String description;
    protected final com.sinacloud.scs.event.ProgressListenerChain progressListenerChain;
    protected final ProgressListenerCallbackExecutor progressListenerChainCallbackExecutor;
    protected final Collection<TransferStateChangeListener> stateChangeListeners = new LinkedList<TransferStateChangeListener>();

    AbstractTransfer(String description, TransferProgress transferProgress, com.sinacloud.scs.event.ProgressListenerChain progressListenerChain) {
        this(description, transferProgress, progressListenerChain, null);
    }

    @Deprecated
    AbstractTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain) {
        this(description, transferProgress, progressListenerChain, null);
    }

    AbstractTransfer(String description, TransferProgress transferProgress, com.sinacloud.scs.event.ProgressListenerChain progressListenerChain, TransferStateChangeListener stateChangeListener) {
        this.description = description;
        this.progressListenerChain = progressListenerChain;
        this.progressListenerChainCallbackExecutor = ProgressListenerCallbackExecutor.wrapListener(progressListenerChain);
        this.transferProgress = transferProgress;
        this.addStateChangeListener(stateChangeListener);
    }

    @Deprecated
    AbstractTransfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, TransferStateChangeListener stateChangeListener) {
        this(description, transferProgress, progressListenerChain.transformToGeneralProgressListenerChain(), stateChangeListener);
    }

    public synchronized boolean isDone() {
        return this.state == Transfer.TransferState.Failed || this.state == Transfer.TransferState.Completed || this.state == Transfer.TransferState.Canceled;
    }

    public void waitForCompletion() throws SCSClientException, SCSServiceException, InterruptedException {
        try {
            Object result = null;
            while (!this.monitor.isDone() || result == null) {
                Future<?> f = this.monitor.getFuture();
                result = f.get();
            }
        }
        catch (ExecutionException e) {
            this.rethrowExecutionException(e);
        }
    }

    public SCSClientException waitForException() throws InterruptedException {
        try {
            while (!this.monitor.isDone()) {
                this.monitor.getFuture().get();
            }
            this.monitor.getFuture().get();
            return null;
        }
        catch (ExecutionException e) {
            return this.unwrapExecutionException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized Transfer.TransferState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(Transfer.TransferState state) {
        AbstractTransfer abstractTransfer = this;
        synchronized (abstractTransfer) {
            this.state = state;
        }
        for (TransferStateChangeListener listener : this.stateChangeListeners) {
            listener.transferStateChanged(this, state);
        }
    }

    public void notifyStateChangeListeners(Transfer.TransferState state) {
        for (TransferStateChangeListener listener : this.stateChangeListeners) {
            listener.transferStateChanged(this, state);
        }
    }

    public synchronized void addProgressListener(com.sinacloud.scs.event.ProgressListener listener) {
        this.progressListenerChain.addProgressListener(listener);
    }

    public synchronized void removeProgressListener(com.sinacloud.scs.event.ProgressListener listener) {
        this.progressListenerChain.removeProgressListener(listener);
    }

    @Deprecated
    public synchronized void addProgressListener(ProgressListener listener) {
        this.progressListenerChain.addProgressListener(new LegacyS3ProgressListener(listener));
    }

    @Deprecated
    public synchronized void removeProgressListener(ProgressListener listener) {
        this.progressListenerChain.removeProgressListener(new LegacyS3ProgressListener(listener));
    }

    public synchronized void addStateChangeListener(TransferStateChangeListener listener) {
        if (listener != null) {
            this.stateChangeListeners.add(listener);
        }
    }

    public synchronized void removeStateChangeListener(TransferStateChangeListener listener) {
        if (listener != null) {
            this.stateChangeListeners.remove(listener);
        }
    }

    public TransferProgress getProgress() {
        return this.transferProgress;
    }

    public void setMonitor(TransferMonitor monitor) {
        this.monitor = monitor;
    }

    public TransferMonitor getMonitor() {
        return this.monitor;
    }

    protected void fireProgressEvent(int eventType) {
        if (this.progressListenerChainCallbackExecutor == null) {
            return;
        }
        this.progressListenerChainCallbackExecutor.progressChanged(new ProgressEvent(eventType, 0L));
    }

    protected void rethrowExecutionException(ExecutionException e) {
        throw this.unwrapExecutionException(e);
    }

    protected SCSClientException unwrapExecutionException(ExecutionException e) {
        Throwable t = e.getCause();
        if (t instanceof SCSClientException) {
            return (SCSClientException)t;
        }
        return new SCSClientException("Unable to complete transfer: " + t.getMessage(), t);
    }
}

