/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.transfer.internal;

import com.sinacloud.scs.services.scs.model.ObjectMetadata;
import com.sinacloud.scs.services.scs.model.S3Object;
import com.sinacloud.scs.services.scs.transfer.Download;
import com.sinacloud.scs.services.scs.transfer.Transfer;
import com.sinacloud.scs.services.scs.transfer.TransferProgress;
import com.sinacloud.scs.services.scs.transfer.internal.AbstractTransfer;
import com.sinacloud.scs.services.scs.transfer.internal.ProgressListenerChain;
import com.sinacloud.scs.services.scs.transfer.internal.TransferStateChangeListener;
import java.io.IOException;

public class DownloadImpl
extends AbstractTransfer
implements Download {
    S3Object s3Object;

    public DownloadImpl(String description, TransferProgress transferProgress, com.sinacloud.scs.event.ProgressListenerChain progressListenerChain, S3Object s3Object, TransferStateChangeListener listener) {
        super(description, transferProgress, progressListenerChain, listener);
        this.s3Object = s3Object;
    }

    @Deprecated
    public DownloadImpl(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain, S3Object s3Object, TransferStateChangeListener listener) {
        this(description, transferProgress, progressListenerChain.transformToGeneralProgressListenerChain(), s3Object, listener);
    }

    public ObjectMetadata getObjectMetadata() {
        return this.s3Object.getObjectMetadata();
    }

    public String getBucketName() {
        return this.s3Object.getBucketName();
    }

    public String getKey() {
        return this.s3Object.getKey();
    }

    public synchronized void abort() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.s3Object != null) {
            this.s3Object.getObjectContent().abort();
        }
        this.setState(Transfer.TransferState.Canceled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void abortWithoutNotifyingStateChangeListener() throws IOException {
        this.monitor.getFuture().cancel(true);
        if (this.s3Object != null) {
            this.s3Object.getObjectContent().abort();
        }
        DownloadImpl downloadImpl = this;
        synchronized (downloadImpl) {
            this.state = Transfer.TransferState.Canceled;
        }
    }

    public synchronized void setS3Object(S3Object s3Object) {
        this.s3Object = s3Object;
    }

    public void setState(Transfer.TransferState state) {
        super.setState(state);
        if (state == Transfer.TransferState.Completed) {
            this.fireProgressEvent(4);
        }
    }
}

